/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.insertionsort;

import org.apache.sysds.runtime.compress.colgroup.insertionsort.AInsertionSorter;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.utils.IntArrayList;

public class MaterializeSort
extends AInsertionSorter {
    AMapToData md;

    public MaterializeSort(int endLength, int knownMax, IntArrayList[] offsets, int negativeIndex) {
        super(endLength, knownMax, offsets, negativeIndex);
        this.md = MapToFactory.create(this._knownMax, this._numLabels);
        this.md.fill(this._numLabels);
        if (this._negativeIndex == -1) {
            this.insert();
        } else {
            this.insertWithNegative();
        }
    }

    private void insert() {
        for (int i = 0; i < this._offsets.length; ++i) {
            IntArrayList of = this._offsets[i];
            for (int k = 0; k < of.size(); ++k) {
                this.md.set(of.get(k), i);
            }
        }
        int off = 0;
        for (int i = 0; i < this._knownMax; ++i) {
            int idx = this.md.getIndex(i);
            if (idx == this._numLabels) continue;
            this.set(off++, i, idx);
        }
    }

    private void insertWithNegative() {
        for (int i = 0; i < this._offsets.length; ++i) {
            IntArrayList of = this._offsets[i];
            for (int k = 0; k < of.size(); ++k) {
                this.md.set(of.get(k), i);
            }
        }
        int off = 0;
        for (int i = 0; i < this._knownMax; ++i) {
            int idx = this.md.getIndex(i);
            if (idx < this._negativeIndex) {
                this.set(off++, i, idx);
                continue;
            }
            if (idx <= this._negativeIndex) continue;
            this.set(off++, i, idx - 1);
        }
    }
}

