/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.cocode;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.estim.CompressedSizeEstimator;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfo;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;
import org.apache.sysds.runtime.compress.utils.Util;

public abstract class AColumnCoCoder {
    protected static final Log LOG = LogFactory.getLog((String)AColumnCoCoder.class.getName());
    protected final CompressedSizeEstimator _est;
    protected final CompressionSettings _cs;

    protected AColumnCoCoder(CompressedSizeEstimator sizeEstimator, CompressionSettings cs) {
        this._est = sizeEstimator;
        this._cs = cs;
    }

    protected abstract CompressedSizeInfo coCodeColumns(CompressedSizeInfo var1, int var2);

    protected CompressedSizeInfoColGroup join(CompressedSizeInfoColGroup lhs, CompressedSizeInfoColGroup rhs, boolean analyze) {
        return analyze ? this.joinWithAnalysis(lhs, rhs) : this.joinWithoutAnalysis(lhs, rhs);
    }

    protected CompressedSizeInfoColGroup joinWithAnalysis(CompressedSizeInfoColGroup lhs, CompressedSizeInfoColGroup rhs) {
        return this._est.estimateJoinCompressedSize(lhs, rhs);
    }

    protected CompressedSizeInfoColGroup joinWithoutAnalysis(CompressedSizeInfoColGroup lhs, CompressedSizeInfoColGroup rhs) {
        int[] joined = Util.join(lhs.getColumns(), rhs.getColumns());
        int numVals = lhs.getNumVals() + rhs.getNumVals();
        if (numVals < 0 || numVals > this._est.getNumRows()) {
            return null;
        }
        return new CompressedSizeInfoColGroup(joined, numVals, this._est.getNumRows());
    }

    protected CompressedSizeInfoColGroup analyze(CompressedSizeInfoColGroup g) {
        if (g.getBestCompressionType() == null) {
            return this._est.estimateCompressedColGroupSize(g.getColumns());
        }
        return g;
    }
}

