/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops;

import org.apache.sysds.common.Types;
import org.apache.sysds.hops.Hop;
import org.apache.sysds.hops.HopsException;
import org.apache.sysds.hops.MemoTable;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.lops.Data;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.lops.LopsException;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.util.UtilFunctions;

public class LiteralOp
extends Hop {
    private double value_double = Double.NaN;
    private long value_long = Long.MAX_VALUE;
    private String value_string;
    private boolean value_boolean;

    private LiteralOp() {
    }

    public LiteralOp(double value) {
        super(String.valueOf(value), Types.DataType.SCALAR, Types.ValueType.FP64);
        this.value_double = value;
    }

    public LiteralOp(long value) {
        super(String.valueOf(value), Types.DataType.SCALAR, Types.ValueType.INT64);
        this.value_long = value;
    }

    public LiteralOp(String value) {
        super(value, Types.DataType.SCALAR, Types.ValueType.STRING);
        this.value_string = value;
    }

    public LiteralOp(boolean value) {
        super(String.valueOf(value), Types.DataType.SCALAR, Types.ValueType.BOOLEAN);
        this.value_boolean = value;
    }

    public LiteralOp(LiteralOp that) {
        super(that.getName(), that.getDataType(), that.getValueType());
        this.value_double = that.value_double;
        this.value_long = that.value_long;
        this.value_string = that.value_string;
        this.value_boolean = that.value_boolean;
    }

    @Override
    public void checkArity() {
        HopsException.check(this._input.isEmpty(), this, "should have 0 inputs but has %d inputs", this._input.size());
    }

    @Override
    public boolean isGPUEnabled() {
        return false;
    }

    @Override
    public Lop constructLops() {
        if (this.getLops() != null) {
            return this.getLops();
        }
        try {
            Data l = null;
            switch (this.getValueType()) {
                case FP64: {
                    l = Data.createLiteralLop(Types.ValueType.FP64, Double.toString(this.value_double));
                    break;
                }
                case BOOLEAN: {
                    l = Data.createLiteralLop(Types.ValueType.BOOLEAN, Boolean.toString(this.value_boolean));
                    break;
                }
                case STRING: {
                    l = Data.createLiteralLop(Types.ValueType.STRING, this.value_string);
                    break;
                }
                case INT64: {
                    l = Data.createLiteralLop(Types.ValueType.INT64, Long.toString(this.value_long));
                    break;
                }
                default: {
                    throw new HopsException(this.printErrorLocation() + "unexpected value type constructing lops for LiteralOp.\n");
                }
            }
            l.getOutputParameters().setDimensions(0L, 0L, 0L, -1L);
            this.setLineNumbers(l);
            this.setPrivacy(l);
            this.setLops(l);
        }
        catch (LopsException e) {
            throw new HopsException(e);
        }
        return this.getLops();
    }

    @Override
    public String getOpString() {
        String val = null;
        switch (this.getValueType()) {
            case FP64: {
                val = Double.toString(this.value_double);
                break;
            }
            case BOOLEAN: {
                val = Boolean.toString(this.value_boolean);
                break;
            }
            case STRING: {
                val = this.value_string;
                break;
            }
            case INT64: {
                val = Long.toString(this.value_long);
                break;
            }
            default: {
                val = "";
            }
        }
        return "LiteralOp " + val;
    }

    @Override
    protected double computeOutputMemEstimate(long dim1, long dim2, long nnz) {
        double ret = 0.0;
        switch (this.getValueType()) {
            case INT64: {
                ret = 4.0;
                break;
            }
            case FP64: {
                ret = 8.0;
                break;
            }
            case BOOLEAN: {
                ret = 1.0;
                break;
            }
            case STRING: {
                ret = (long)this.value_string.length() * 1L;
                break;
            }
            case UNKNOWN: {
                ret = OptimizerUtils.DEFAULT_SIZE;
                break;
            }
            default: {
                ret = 0.0;
            }
        }
        return ret;
    }

    @Override
    protected double computeIntermediateMemEstimate(long dim1, long dim2, long nnz) {
        return 0.0;
    }

    @Override
    protected DataCharacteristics inferOutputCharacteristics(MemoTable memo) {
        return null;
    }

    @Override
    public boolean allowsAllExecTypes() {
        return false;
    }

    @Override
    protected Types.ExecType optFindExecType() {
        return null;
    }

    @Override
    public void refreshSizeInformation() {
    }

    public long getLongValue() {
        switch (this.getValueType()) {
            case INT64: {
                return this.value_long;
            }
            case FP64: {
                return UtilFunctions.toLong(this.value_double);
            }
            case STRING: {
                return Long.parseLong(this.value_string);
            }
            case BOOLEAN: {
                return this.value_boolean ? 1L : 0L;
            }
        }
        return -1L;
    }

    public double getDoubleValue() {
        switch (this.getValueType()) {
            case INT64: {
                return this.value_long;
            }
            case FP64: {
                return this.value_double;
            }
            case STRING: {
                return Double.parseDouble(this.value_string);
            }
            case BOOLEAN: {
                return this.value_boolean ? 1.0 : 0.0;
            }
        }
        throw new HopsException("Can not coerce an object of type " + (Object)((Object)this.getValueType()) + " into Double.");
    }

    public boolean getBooleanValue() {
        switch (this.getValueType()) {
            case INT64: {
                return this.value_long != 0L;
            }
            case FP64: {
                return this.value_double != 0.0;
            }
            case STRING: {
                return Boolean.parseBoolean(this.value_string);
            }
            case BOOLEAN: {
                return this.value_boolean;
            }
        }
        throw new HopsException("Can not coerce an object of type " + (Object)((Object)this.getValueType()) + " into Boolean.");
    }

    public String getStringValue() {
        switch (this.getValueType()) {
            case BOOLEAN: {
                return String.valueOf(this.value_boolean);
            }
            case INT64: 
            case UINT8: 
            case INT32: {
                return String.valueOf(this.value_long);
            }
            case FP64: 
            case FP32: {
                return String.valueOf(this.value_double);
            }
            case STRING: {
                return this.value_string;
            }
        }
        return null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        LiteralOp ret = new LiteralOp();
        ret.clone(this, false);
        ret.value_double = this.value_double;
        ret.value_long = this.value_long;
        ret.value_string = this.value_string;
        ret.value_boolean = this.value_boolean;
        return ret;
    }

    @Override
    public boolean compare(Hop that) {
        return false;
    }

    @Override
    public String toString() {
        return this.getOpString();
    }
}

