/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.util;

import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.SynapseCommonsException;

public class RMIRegistryController {
    public static final Log log = LogFactory.getLog(RMIRegistryController.class);
    private static RMIRegistryController ourInstance = new RMIRegistryController();
    private final Map<String, Registry> registriesCache = new HashMap<String, Registry>();

    public static RMIRegistryController getInstance() {
        return ourInstance;
    }

    private RMIRegistryController() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createLocalRegistry(int port) {
        try {
            String key = RMIRegistryController.toKey(port);
            Map<String, Registry> map = this.registriesCache;
            synchronized (map) {
                if (this.registriesCache.containsKey(key)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("There is an RMI registry bound to given port :" + port));
                    }
                    return;
                }
                Registry locateRegistry = LocateRegistry.createRegistry(port);
                if (locateRegistry == null) {
                    RMIRegistryController.handleException("Unable to create a RMI registry with port : " + port);
                }
                this.registriesCache.put(key, locateRegistry);
            }
        }
        catch (RemoteException e) {
            String msg = "Couldn't create a local registry(RMI) : port " + port + " already in use.";
            RMIRegistryController.handleException(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalRegistry(int port) {
        String key = RMIRegistryController.toKey(port);
        Map<String, Registry> map = this.registriesCache;
        synchronized (map) {
            if (this.registriesCache.containsKey(key)) {
                this.removeRegistry(key, this.registriesCache.get(key));
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("There is no RMi registry for port : " + port));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        Map<String, Registry> map = this.registriesCache;
        synchronized (map) {
            ArrayList<String> registryKeys = new ArrayList<String>(this.registriesCache.size());
            registryKeys.addAll(this.registriesCache.keySet());
            for (String key : registryKeys) {
                this.removeRegistry(key, this.registriesCache.get(key));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRegistry(String key, Registry registry) {
        if (registry != null) {
            Map<String, Registry> map = this.registriesCache;
            synchronized (map) {
                try {
                    log.info((Object)("Removing the RMI registry bound to port : " + key));
                    UnicastRemoteObject.unexportObject(registry, true);
                    this.registriesCache.remove(key);
                }
                catch (NoSuchObjectException e) {
                    String msg = "Error when stopping local registry(RMI)";
                    RMIRegistryController.handleException(msg, e);
                }
            }
        }
    }

    private static String toKey(int port) {
        RMIRegistryController.assertPositive(port);
        return String.valueOf(port);
    }

    private static void assertPositive(int port) {
        if (port < 0) {
            RMIRegistryController.handleException("Invalid port number : " + port);
        }
    }

    private static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseCommonsException(msg, e);
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseCommonsException(msg);
    }
}

