/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.utils.conn;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.MessageConstraints;
import org.apache.http.entity.ContentLengthStrategy;
import org.apache.http.impl.ConnSupport;
import org.apache.http.impl.entity.StrictContentLengthStrategy;
import org.apache.http.impl.nio.DefaultNHttpClientConnection;
import org.apache.http.impl.nio.codecs.DefaultHttpRequestWriter;
import org.apache.http.impl.nio.codecs.DefaultHttpResponseParser;
import org.apache.http.nio.NHttpConnectionFactory;
import org.apache.http.nio.NHttpMessageParser;
import org.apache.http.nio.NHttpMessageParserFactory;
import org.apache.http.nio.NHttpMessageWriter;
import org.apache.http.nio.NHttpMessageWriterFactory;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.SessionInputBuffer;
import org.apache.http.nio.reactor.SessionOutputBuffer;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.synapse.transport.nhttp.AccessHandler;
import org.apache.synapse.transport.utils.conn.SynapseNHttpClientConnection;
import org.apache.synapse.transport.utils.conn.logging.LoggingIOSession;
import org.apache.synapse.transport.utils.conn.logging.LoggingNHttpClientConnection;

public class SynapseNHttpClientConnectionFactory
implements NHttpConnectionFactory<DefaultNHttpClientConnection> {
    private static final Log targetConnLog = LogFactory.getLog((String)"org.apache.synapse.transport.http.conn.TargetConnection");
    private static final Log targetHeaderLog = LogFactory.getLog((String)"org.apache.synapse.transport.http.headers.TargetHeaders");
    private static final Log targetSessionLog = LogFactory.getLog((String)"org.apache.synapse.transport.http.session.TargetSession");
    private static final Log targetWireLog = LogFactory.getLog((String)"org.apache.synapse.transport.http.wire.TargetWire");
    private static final NHttpMessageWriterFactory<HttpRequest> requestWriterFactory = new LoggingNHttpRequestWriterFactory();
    private static final NHttpMessageParserFactory<HttpResponse> responseParserFactory = new LoggingNHttpResponseParserFactory();
    private final ConnectionConfig config;

    public SynapseNHttpClientConnectionFactory(ConnectionConfig config) {
        this.config = config;
    }

    public DefaultNHttpClientConnection createConnection(IOSession session) {
        if (targetSessionLog.isDebugEnabled() || targetWireLog.isDebugEnabled()) {
            session = new LoggingIOSession(targetSessionLog, targetWireLog, session, "http-sender");
        }
        if (targetConnLog.isDebugEnabled() || targetHeaderLog.isDebugEnabled()) {
            return new LoggingNHttpClientConnection(session, this.config.getBufferSize(), this.config.getFragmentSizeHint(), (ByteBufferAllocator)HeapByteBufferAllocator.INSTANCE, ConnSupport.createDecoder((ConnectionConfig)this.config), ConnSupport.createEncoder((ConnectionConfig)this.config), this.config.getMessageConstraints(), (ContentLengthStrategy)StrictContentLengthStrategy.INSTANCE, (ContentLengthStrategy)StrictContentLengthStrategy.INSTANCE, requestWriterFactory, responseParserFactory, targetConnLog);
        }
        return new SynapseNHttpClientConnection(session, this.config.getBufferSize(), this.config.getFragmentSizeHint(), (ByteBufferAllocator)HeapByteBufferAllocator.INSTANCE, ConnSupport.createDecoder((ConnectionConfig)this.config), ConnSupport.createEncoder((ConnectionConfig)this.config), this.config.getMessageConstraints(), (ContentLengthStrategy)StrictContentLengthStrategy.INSTANCE, (ContentLengthStrategy)StrictContentLengthStrategy.INSTANCE, requestWriterFactory, responseParserFactory);
    }

    static class LoggingNHttpResponseParser
    extends DefaultHttpResponseParser {
        public LoggingNHttpResponseParser(SessionInputBuffer buffer, MessageConstraints constraints) {
            super(buffer, constraints);
        }

        public HttpResponse parse() throws IOException, HttpException {
            HttpResponse response = (HttpResponse)super.parse();
            if (response != null) {
                if (targetHeaderLog.isDebugEnabled()) {
                    Header[] headers;
                    targetHeaderLog.debug((Object)("<< " + response.getStatusLine().toString()));
                    for (Header header : headers = response.getAllHeaders()) {
                        targetHeaderLog.debug((Object)("<< " + header.toString()));
                    }
                }
                if (AccessHandler.getAccessLog().isInfoEnabled()) {
                    AccessHandler.getAccess().addAccessToQueue(response);
                }
            }
            return response;
        }
    }

    static class LoggingNHttpRequestWriter
    extends DefaultHttpRequestWriter {
        public LoggingNHttpRequestWriter(SessionOutputBuffer buffer) {
            super(buffer);
        }

        public void write(HttpRequest request) throws IOException, HttpException {
            if (request != null) {
                if (targetHeaderLog.isDebugEnabled()) {
                    Header[] headers;
                    targetHeaderLog.debug((Object)(">> " + request.getRequestLine().toString()));
                    for (Header header : headers = request.getAllHeaders()) {
                        targetHeaderLog.debug((Object)(">> " + header.toString()));
                    }
                }
                if (AccessHandler.getAccessLog().isInfoEnabled()) {
                    AccessHandler.getAccess().addAccessToQueue(request);
                }
            }
            super.write((HttpMessage)request);
        }
    }

    static class LoggingNHttpResponseParserFactory
    implements NHttpMessageParserFactory<HttpResponse> {
        LoggingNHttpResponseParserFactory() {
        }

        public NHttpMessageParser<HttpResponse> create(SessionInputBuffer sessionBuffer, MessageConstraints messageConstraints) {
            return new LoggingNHttpResponseParser(sessionBuffer, messageConstraints);
        }
    }

    static class LoggingNHttpRequestWriterFactory
    implements NHttpMessageWriterFactory<HttpRequest> {
        LoggingNHttpRequestWriterFactory() {
        }

        public NHttpMessageWriter<HttpRequest> create(SessionOutputBuffer sessionBuffer) {
            return new LoggingNHttpRequestWriter(sessionBuffer);
        }
    }
}

