/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.caching;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.state.StateClusteringCommand;
import org.apache.axis2.context.ConfigurationContext;
import org.wso2.caching.CachableResponse;
import org.wso2.caching.CacheManager;
import org.wso2.caching.RequestHash;
import org.wso2.caching.ServiceName;

public class CacheReplicationCommand
extends StateClusteringCommand {
    private List<AddedCachedResponse> addedItems = new ArrayList<AddedCachedResponse>();
    private List<RemovedCachedResponse> removedItems = new ArrayList<RemovedCachedResponse>();

    public void addCachedReponse(ServiceName serviceName, RequestHash requestHash, CachableResponse response) {
        this.addedItems.add(new AddedCachedResponse(serviceName, requestHash, response));
    }

    public void removeCachedResponse(ServiceName serviceName, RequestHash requestHash) {
        this.removedItems.add(new RemovedCachedResponse(serviceName, requestHash));
    }

    public void execute(ConfigurationContext configurationContext) throws ClusteringFault {
        CacheManager cacheManager = (CacheManager)configurationContext.getPropertyNonReplicable("cacheManager");
        for (AddedCachedResponse addedItem : this.addedItems) {
            cacheManager.cacheResponse(addedItem.getServiceName(), addedItem.getRequestHash(), addedItem.getResponse());
        }
        for (RemovedCachedResponse removedItem : this.removedItems) {
            cacheManager.removeExpiredResponse(removedItem.getServiceName(), removedItem.getRequestHash());
        }
    }

    public String toString() {
        return "CacheReplicationCommand";
    }

    private static class AddedCachedResponse
    implements Serializable {
        private ServiceName serviceName;
        private RequestHash requestHash;
        private CachableResponse response;

        private AddedCachedResponse(ServiceName serviceName, RequestHash requestHash, CachableResponse response) {
            this.serviceName = serviceName;
            this.requestHash = requestHash;
            this.response = response;
        }

        public ServiceName getServiceName() {
            return this.serviceName;
        }

        public RequestHash getRequestHash() {
            return this.requestHash;
        }

        public CachableResponse getResponse() {
            return this.response;
        }
    }

    private static class RemovedCachedResponse
    implements Serializable {
        private ServiceName serviceName;
        private RequestHash requestHash;

        private RemovedCachedResponse(ServiceName serviceName, RequestHash requestHash) {
            this.serviceName = serviceName;
            this.requestHash = requestHash;
        }

        public ServiceName getServiceName() {
            return this.serviceName;
        }

        public RequestHash getRequestHash() {
            return this.requestHash;
        }
    }
}

