/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.amqp.sendertask;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.base.BaseUtils;
import org.apache.axis2.util.MessageProcessorSelector;
import org.apache.synapse.transport.amqp.AMQPTransportException;

public class AMQPSender {
    private Channel channel = null;
    private String queueName = null;
    private String exchangeName = null;
    private String routingKey = null;

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public void setExchangeName(String exchangeName) {
        this.exchangeName = exchangeName;
    }

    public void setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void sendAMQPMessage(MessageContext mc, String correlationId, String replyTo) throws AMQPTransportException, IOException {
        String clusterId;
        String appId;
        String userId;
        String type;
        String timeStamp;
        String expiration;
        String priority;
        String deliverMode;
        String encoding;
        MessageFormatter formatter;
        OMOutputFormat format = BaseUtils.getOMOutputFormat((MessageContext)mc);
        try {
            formatter = MessageProcessorSelector.getMessageFormatter((MessageContext)mc);
        }
        catch (AxisFault axisFault) {
            throw new AxisFault("Unable to get the message formatter to use");
        }
        AMQP.BasicProperties.Builder builder = new AMQP.BasicProperties().builder();
        String msgId = this.getProperty(mc, "AMQP_MESSAGE_ID");
        if (msgId == null) {
            msgId = mc.getMessageID();
        }
        builder.messageId(msgId);
        String contentType = this.getProperty(mc, "AMQP_CONTENT_TYPE");
        if (contentType == null) {
            contentType = this.getProperty(mc, "ContentType");
        }
        if (contentType != null) {
            builder.contentType(contentType);
        }
        if (correlationId != null) {
            builder.correlationId(correlationId);
        }
        if (replyTo != null) {
            builder.replyTo(replyTo);
        }
        if ((encoding = this.getProperty(mc, "AMQP_CONTENT_ENCODING")) == null) {
            encoding = this.getProperty(mc, "CHARACTER_SET_ENCODING");
        }
        if (encoding != null) {
            builder.contentEncoding(encoding);
        }
        if ((deliverMode = this.getProperty(mc, "AMQP_DELIVERY_MODE")) != null) {
            builder.deliveryMode(Integer.valueOf(Integer.parseInt(deliverMode)));
        }
        if ((priority = this.getProperty(mc, "AMQP_PRIORITY")) != null) {
            builder.priority(Integer.valueOf(Integer.parseInt(priority)));
        }
        if ((expiration = this.getProperty(mc, "AMQP_EXPIRATION")) != null) {
            builder.expiration(expiration);
        }
        if ((timeStamp = this.getProperty(mc, "AMQP_TIME_STAMP")) != null) {
            builder.timestamp(new Date(Long.parseLong(timeStamp)));
        }
        if ((type = this.getProperty(mc, "AMQP_TYPE")) != null) {
            builder.type(type);
        }
        if ((userId = this.getProperty(mc, "AMQP_USER_ID")) != null) {
            builder.type(userId);
        }
        if ((appId = this.getProperty(mc, "AMQP_APP_ID")) != null) {
            builder.appId(appId);
        }
        if ((clusterId = this.getProperty(mc, "AMQP_CLUSTER_ID")) != null) {
            builder.clusterId(clusterId);
        }
        HashMap headers = new HashMap();
        Map prop = mc.getProperties();
        for (String key : prop.keySet()) {
            if (!key.contains("AMQP_HEADER")) continue;
            headers.put(key, prop.get(key));
        }
        builder.headers(headers);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        formatter.writeTo(mc, format, (OutputStream)out, false);
        byte[] msg = out.toByteArray();
        if (this.exchangeName != null) {
            if (this.routingKey != null) {
                this.channel.basicPublish(this.exchangeName, this.routingKey, builder.build(), msg);
            } else {
                this.channel.basicPublish(this.exchangeName, "", builder.build(), msg);
            }
        } else {
            this.channel.basicPublish("", this.queueName, builder.build(), msg);
        }
    }

    private String getProperty(MessageContext mc, String key) {
        return (String)mc.getProperty(key);
    }
}

