/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.builtin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.FaultHandler;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.mediators.AbstractListMediator;
import org.apache.synapse.mediators.MediatorProperty;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.util.AXIOMUtils;
import org.apache.synapse.util.jaxp.SchemaResourceResolver;
import org.apache.synapse.util.resolver.ResourceMap;
import org.apache.synapse.util.resolver.UserDefinedXmlSchemaURIResolver;
import org.apache.synapse.util.xpath.SourceXPathSupport;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ValidateMediator
extends AbstractListMediator {
    private List<Value> schemaKeys = new ArrayList<Value>();
    private ResourceMap resourceMap;
    private final SourceXPathSupport source = new SourceXPathSupport();
    private final List<MediatorProperty> explicityFeatures = new ArrayList<MediatorProperty>();
    private Schema cachedSchema;
    private final Object validatorLock = new Object();
    private final SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mediate(MessageContext synCtx) {
        SynapseLog synLog = this.getLog(synCtx);
        synLog.traceOrDebug("Start : Validate mediator");
        if (synLog.isTraceTraceEnabled()) {
            synLog.traceTrace("Message : " + synCtx.getEnvelope());
        }
        Source validateSrc = this.getValidationSource(synCtx, synLog);
        boolean reCreate = false;
        for (Value value : this.schemaKeys) {
            String propKey = value.evaluateValue(synCtx);
            Entry dp = synCtx.getConfiguration().getEntryDefinition(propKey);
            if (dp == null || !dp.isDynamic() || dp.isCached() && !dp.isExpired()) continue;
            reCreate = true;
        }
        ValidateMediatorErrorHandler errorHandler = new ValidateMediatorErrorHandler();
        Object object = this.validatorLock;
        synchronized (object) {
            if (reCreate || this.cachedSchema == null) {
                this.factory.setErrorHandler(errorHandler);
                Source[] sources = new StreamSource[this.schemaKeys.size()];
                int i = 0;
                for (Value schemaKey3 : this.schemaKeys) {
                    String propName = schemaKey3.evaluateValue(synCtx);
                    sources[i++] = SynapseConfigUtils.getStreamSource(synCtx.getEntry(propName));
                }
                try {
                    SynapseConfiguration synCfg = synCtx.getConfiguration();
                    if (synCfg.getProperty("synapse.schema.resolver") != null) {
                        this.setUserDefinedSchemaResourceResolver(synCtx);
                    } else {
                        this.factory.setResourceResolver(new SchemaResourceResolver(synCtx.getConfiguration(), this.resourceMap));
                    }
                    this.cachedSchema = this.factory.newSchema(sources);
                }
                catch (SAXException e) {
                    this.handleException("Error creating a new schema objects for schemas : " + this.schemaKeys.toString(), e, synCtx);
                }
                catch (RuntimeException e) {
                    this.handleException("Error creating a new schema objects for schemas : " + this.schemaKeys.toString(), e, synCtx);
                }
                if (errorHandler.isValidationError()) {
                    errorHandler.setValidationError(false);
                    this.cachedSchema = null;
                    this.handleException("Error creating a new schema objects for schemas : " + this.schemaKeys.toString(), errorHandler.getSaxParseException(), synCtx);
                }
            }
        }
        try {
            Validator validator = this.cachedSchema.newValidator();
            validator.setErrorHandler(errorHandler);
            validator.validate(validateSrc);
            if (errorHandler.isValidationError()) {
                if (synLog.isTraceOrDebugEnabled()) {
                    String msg = "Validation of element returned by XPath : " + this.source + " failed against the given schema(s) " + this.schemaKeys + "with error : " + errorHandler.getSaxParseException().getMessage() + " Executing 'on-fail' sequence";
                    synLog.traceOrDebug(msg);
                    synCtx.getServiceLog().warn((Object)msg);
                    if (synLog.isTraceTraceEnabled()) {
                        synLog.traceTrace("Failed message envelope : " + synCtx.getEnvelope());
                    }
                }
                synCtx.setProperty("ERROR_MESSAGE", errorHandler.getSaxParseException().getMessage());
                synCtx.setProperty("ERROR_EXCEPTION", errorHandler.getSaxParseException());
                synCtx.setProperty("ERROR_DETAIL", FaultHandler.getStackTrace(errorHandler.getSaxParseException()));
                return super.mediate(synCtx);
            }
        }
        catch (SAXException sAXException) {
            this.handleException("Error validating " + this.source + " element", sAXException, synCtx);
        }
        catch (IOException iOException) {
            this.handleException("Error validating " + this.source + " element", iOException, synCtx);
        }
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Validation of element returned by the XPath expression : " + this.source + " succeeded against the given schemas and the current message");
            synLog.traceOrDebug("End : Validate mediator");
        }
        return true;
    }

    private void setUserDefinedSchemaResourceResolver(MessageContext synCtx) {
        Class<?> schemaClazz;
        SynapseConfiguration synCfg = synCtx.getConfiguration();
        String schemaResolverName = synCfg.getProperty("synapse.schema.resolver");
        try {
            schemaClazz = Class.forName(schemaResolverName);
        }
        catch (ClassNotFoundException e) {
            String msg = "System could not find the class defined for the specific properties\n SchemaResolverImplementation:" + schemaResolverName;
            this.handleException(msg, e, synCtx);
            return;
        }
        try {
            Object schemaClazzObject = schemaClazz.newInstance();
            UserDefinedXmlSchemaURIResolver userDefSchemaResResolver = (UserDefinedXmlSchemaURIResolver)schemaClazzObject;
            userDefSchemaResResolver.init(this.resourceMap, synCfg, this.schemaKeys);
            this.factory.setResourceResolver(userDefSchemaResResolver);
        }
        catch (Exception e) {
            String msg = "Could not create an instance from the class";
            this.handleException(msg, e, synCtx);
        }
    }

    private Source getValidationSource(MessageContext synCtx, SynapseLog synLog) {
        try {
            OMNode validateSource = this.source.selectOMNode(synCtx, synLog);
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("Validation source : " + validateSource.toString());
            }
            return AXIOMUtils.asSource(validateSource);
        }
        catch (Exception e) {
            this.handleException("Error accessing source element : " + this.source, e, synCtx);
            return null;
        }
    }

    public Object getFeature(String key) {
        for (MediatorProperty prop : this.explicityFeatures) {
            if (!key.equals(prop.getName())) continue;
            return prop.getValue();
        }
        return null;
    }

    public void addFeature(String featureName, boolean isFeatureEnable) throws SAXException {
        MediatorProperty mp = new MediatorProperty();
        mp.setName(featureName);
        if (isFeatureEnable) {
            mp.setValue("true");
        } else {
            mp.setValue("false");
        }
        this.explicityFeatures.add(mp);
        this.factory.setFeature(featureName, isFeatureEnable);
    }

    public void setSchemaKeys(List<Value> schemaKeys) {
        this.schemaKeys = schemaKeys;
    }

    public void setSource(SynapseXPath source) {
        this.source.setXPath(source);
    }

    public void setResourceMap(ResourceMap resourceMap) {
        this.resourceMap = resourceMap;
    }

    public SynapseXPath getSource() {
        return this.source.getXPath();
    }

    public List<Value> getSchemaKeys() {
        return this.schemaKeys;
    }

    public List<MediatorProperty> getFeatures() {
        return this.explicityFeatures;
    }

    public ResourceMap getResourceMap() {
        return this.resourceMap;
    }

    @Override
    public boolean isContentAware() {
        return true;
    }

    private static class ValidateMediatorErrorHandler
    extends DefaultHandler {
        private boolean validationError = false;
        private SAXParseException saxParseException = null;

        private ValidateMediatorErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.validationError = true;
            this.saxParseException = exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.validationError = true;
            this.saxParseException = exception;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
        }

        public boolean isValidationError() {
            return this.validationError;
        }

        public SAXParseException getSaxParseException() {
            return this.saxParseException;
        }

        public void setValidationError(boolean validationError) {
            this.validationError = validationError;
        }
    }
}

