/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.eventing.filters;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;
import org.wso2.eventing.Event;
import org.wso2.eventing.EventFilter;

public class TopicBasedEventFilter
implements EventFilter<MessageContext> {
    private AXIOMXPath sourceXpath;
    private String resultValue;
    private static final String FILTER_SEP = "/";
    private static final Log log = LogFactory.getLog(TopicBasedEventFilter.class);

    public String getResultValue() {
        return this.resultValue;
    }

    public void setResultValue(String resultValue) {
        this.resultValue = resultValue;
    }

    public String toString() {
        return this.resultValue;
    }

    public AXIOMXPath getSourceXpath() {
        return this.sourceXpath;
    }

    public void setSourceXpath(SynapseXPath sourceXpath) {
        this.sourceXpath = sourceXpath;
    }

    public boolean match(Event<MessageContext> event) {
        MessageContext messageContext = (MessageContext)event.getMessage();
        String evaluatedValue = null;
        try {
            OMElement topicNode = (OMElement)this.sourceXpath.selectSingleNode((Object)messageContext.getEnvelope());
            if (topicNode != null) {
                evaluatedValue = topicNode.getText();
            }
        }
        catch (JaxenException e) {
            this.handleException("Error creating topic xpath", (Exception)((Object)e));
        }
        if (evaluatedValue != null) {
            if (evaluatedValue.equals(this.resultValue)) {
                return true;
            }
            if (evaluatedValue.startsWith((this.resultValue + FILTER_SEP).trim())) {
                return true;
            }
        }
        return false;
    }

    private void handleException(String message, Exception e) {
        log.error((Object)message, (Throwable)e);
        throw new SynapseException(message, e);
    }
}

