/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.ValueFactory;
import org.apache.synapse.mediators.TemplateParameter;
import org.apache.synapse.mediators.Value;

public class TemplateParameterFactory {
    private static final Log log = LogFactory.getLog(TemplateParameterFactory.class);

    public static List<TemplateParameter> getTemplateParameters(OMElement elem) {
        ArrayList<TemplateParameter> parameterList = new ArrayList<TemplateParameter>();
        Iterator iter = elem.getChildrenWithName(TemplateParameter.PARAMETER_Q);
        while (iter.hasNext()) {
            String msg;
            OMElement paramEle = (OMElement)iter.next();
            OMAttribute attName = paramEle.getAttribute(TemplateParameter.ATT_NAME_Q);
            OMAttribute attDefault = paramEle.getAttribute(TemplateParameter.ATT_DEFAULT_Q);
            OMAttribute attOptional = paramEle.getAttribute(TemplateParameter.ATT_OPTIONAL_Q);
            TemplateParameter param = new TemplateParameter();
            if (attName == null || attName.getAttributeValue() == null || attName.getAttributeValue().trim().length() == 0) {
                msg = "Parameter name is a required attribute for a Template Parameter";
                log.error((Object)msg);
                throw new SynapseException(msg);
            }
            param.setName(attName.getAttributeValue());
            if (attDefault == null || attDefault.getAttributeValue() == null || attDefault.getAttributeValue().trim().length() == 0) {
                msg = "Default value is not specified for " + param.getName() + " Parameter";
                log.warn((Object)msg);
            } else {
                Value paramValue = new ValueFactory().createValue("default", paramEle);
                param.setDefaultValue(paramValue);
            }
            if (attOptional != null && attOptional.getAttributeValue() != null && attOptional.getAttributeValue().trim().length() != 0) {
                param.setOptional(Boolean.valueOf(attOptional.getAttributeValue()));
            }
            parameterList.add(param);
        }
        return parameterList;
    }
}

