/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorSerializer;
import org.apache.synapse.config.xml.SynapseXPathSerializer;
import org.apache.synapse.config.xml.endpoints.EndpointSerializer;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.mediators.builtin.CalloutMediator;

public class CalloutMediatorSerializer
extends AbstractMediatorSerializer {
    @Override
    public OMElement serializeSpecificMediator(Mediator m) {
        Endpoint endpoint;
        if (!(m instanceof CalloutMediator)) {
            this.handleException("Unsupported mediator passed in for serialization : " + m.getType());
            return null;
        }
        CalloutMediator mediator = (CalloutMediator)m;
        OMElement callout = fac.createOMElement("callout", synNS);
        CalloutMediatorSerializer.saveTracingState(callout, mediator);
        if (mediator.getServiceURL() != null) {
            callout.addAttribute(fac.createOMAttribute("serviceURL", nullNS, mediator.getServiceURL()));
        }
        if ((endpoint = mediator.getEndpoint()) != null) {
            callout.addChild((OMNode)EndpointSerializer.getElementFromEndpoint(endpoint));
        }
        if (mediator.getAction() != null) {
            callout.addAttribute(fac.createOMAttribute("action", nullNS, mediator.getAction()));
        }
        if (mediator.getClientRepository() != null || mediator.getAxis2xml() != null) {
            OMElement config = fac.createOMElement("configuration", synNS);
            if (mediator.getClientRepository() != null) {
                config.addAttribute(fac.createOMAttribute("repository", nullNS, mediator.getClientRepository()));
            }
            if (mediator.getAxis2xml() != null) {
                config.addAttribute(fac.createOMAttribute("axis2xml", nullNS, mediator.getAxis2xml()));
            }
            callout.addChild((OMNode)config);
        }
        if (mediator.isPassHeaders()) {
            callout.addAttribute(fac.createOMAttribute("passHeaders", nullNS, "true"));
        }
        if (!mediator.isInitClientOptions()) {
            callout.addAttribute(fac.createOMAttribute("initAxis2ClientOptions", nullNS, "false"));
        }
        if (mediator.getRequestXPath() != null || mediator.getRequestKey() != null) {
            OMElement source = fac.createOMElement("source", synNS, (OMContainer)callout);
            if (mediator.getRequestXPath() != null) {
                SynapseXPathSerializer.serializeXPath(mediator.getRequestXPath(), source, "xpath");
            } else if (mediator.getRequestKey() != null) {
                source.addAttribute(fac.createOMAttribute("key", nullNS, mediator.getRequestKey()));
            }
        }
        if (mediator.getTargetXPath() != null || mediator.getTargetKey() != null) {
            OMElement target = fac.createOMElement("target", synNS, (OMContainer)callout);
            if (mediator.getTargetXPath() != null) {
                SynapseXPathSerializer.serializeXPath(mediator.getTargetXPath(), target, "xpath");
            } else if (mediator.getTargetKey() != null) {
                target.addAttribute(fac.createOMAttribute("key", nullNS, mediator.getTargetKey()));
            }
        }
        if (mediator.isSecurityOn()) {
            OMElement security = fac.createOMElement("enableSec", synNS);
            if (mediator.getWsSecPolicyKey() != null) {
                security.addAttribute(fac.createOMAttribute("policy", nullNS, mediator.getWsSecPolicyKey()));
                callout.addChild((OMNode)security);
            } else if (mediator.getOutboundWsSecPolicyKey() != null || mediator.getInboundWsSecPolicyKey() != null) {
                if (mediator.getOutboundWsSecPolicyKey() != null) {
                    security.addAttribute(fac.createOMAttribute("outboundPolicy", nullNS, mediator.getOutboundWsSecPolicyKey()));
                }
                if (mediator.getInboundWsSecPolicyKey() != null) {
                    security.addAttribute(fac.createOMAttribute("inboundPolicy", nullNS, mediator.getInboundWsSecPolicyKey()));
                }
                callout.addChild((OMNode)security);
            }
        }
        return callout;
    }

    @Override
    public String getMediatorClassName() {
        return CalloutMediator.class.getName();
    }
}

