/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.Color;
import java.io.Serializable;
import net.sf.jasperreports.engine.Deduplicable;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPenContainer;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import net.sf.jasperreports.engine.util.ObjectUtils;
import net.sf.jasperreports.engine.util.StyleResolver;

public class JRBasePen
implements JRPen,
Serializable,
Cloneable,
JRChangeEventsSupport,
Deduplicable {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_LINE_WIDTH = "lineWidth";
    public static final String PROPERTY_LINE_STYLE = "lineStyle";
    public static final String PROPERTY_LINE_COLOR = "lineColor";
    protected JRPenContainer penContainer;
    protected Float lineWidth;
    protected LineStyleEnum lineStyle;
    protected Color lineColor;
    private transient JRPropertyChangeSupport eventSupport;

    public JRBasePen() {
        this(null);
    }

    public JRBasePen(JRPenContainer penContainer) {
        this.penContainer = penContainer;
    }

    @Override
    public JRPenContainer getPenContainer() {
        return this.penContainer;
    }

    protected StyleResolver getStyleResolver() {
        if (this.getPenContainer().getDefaultStyleProvider() != null) {
            return this.getPenContainer().getDefaultStyleProvider().getStyleResolver();
        }
        return StyleResolver.getInstance();
    }

    @Override
    public Float getLineWidth() {
        return this.getStyleResolver().getLineWidth(this, this.penContainer.getDefaultLineWidth());
    }

    @Override
    public Float getOwnLineWidth() {
        return this.lineWidth;
    }

    @Override
    public void setLineWidth(Float lineWidth) {
        Float old = this.lineWidth;
        this.lineWidth = lineWidth;
        this.getEventSupport().firePropertyChange(PROPERTY_LINE_WIDTH, old, this.lineWidth);
    }

    @Override
    public LineStyleEnum getLineStyle() {
        return this.getStyleResolver().getLineStyle(this);
    }

    @Override
    public LineStyleEnum getOwnLineStyle() {
        return this.lineStyle;
    }

    @Override
    public void setLineStyle(LineStyleEnum lineStyle) {
        LineStyleEnum old = this.lineStyle;
        this.lineStyle = lineStyle;
        this.getEventSupport().firePropertyChange(PROPERTY_LINE_STYLE, old, this.lineStyle);
    }

    @Override
    public Color getLineColor() {
        return this.getStyleResolver().getLineColor(this, this.penContainer.getDefaultLineColor());
    }

    @Override
    public Color getOwnLineColor() {
        return this.lineColor;
    }

    @Override
    public void setLineColor(Color lineColor) {
        Color old = this.lineColor;
        this.lineColor = lineColor;
        this.getEventSupport().firePropertyChange(PROPERTY_LINE_COLOR, old, this.lineColor);
    }

    public String getStyleNameReference() {
        return null;
    }

    @Override
    public JRPen clone(JRPenContainer penContainer) {
        JRBasePen clone = null;
        try {
            clone = (JRBasePen)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
        clone.penContainer = penContainer;
        clone.eventSupport = null;
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JRPropertyChangeSupport getEventSupport() {
        JRBasePen jRBasePen = this;
        synchronized (jRBasePen) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    @Override
    public int getHashCode() {
        ObjectUtils.HashCode hash = ObjectUtils.hash();
        hash.add(this.lineWidth);
        hash.add(this.lineStyle);
        hash.add(this.lineColor);
        return hash.getHashCode();
    }

    @Override
    public boolean isIdentical(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JRBasePen)) {
            return false;
        }
        JRBasePen pen = (JRBasePen)object;
        return ObjectUtils.equals(this.lineWidth, pen.lineWidth) && ObjectUtils.equals(this.lineStyle, pen.lineStyle) && ObjectUtils.equals(this.lineColor, pen.lineColor);
    }

    @Override
    public void populateStyle() {
        this.lineWidth = this.getLineWidth();
        this.lineStyle = this.getLineStyle();
        this.lineColor = this.getLineColor();
    }
}

