/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.commons.collections4.bloomfilter;

import org.apache.storm.shade.org.apache.commons.collections4.bloomfilter.BitMaps;

public final class Shape {
    private static final double LN_2 = Math.log(2.0);
    private static final double DENOMINATOR = -LN_2 * LN_2;
    private final int numberOfHashFunctions;
    private final int numberOfBits;

    private static int calculateNumberOfHashFunctions(int numberOfItems, int numberOfBits) {
        long k = Math.round(LN_2 * (double)numberOfBits / (double)numberOfItems);
        if (k < 1L) {
            throw new IllegalArgumentException(String.format("Filter too small: Calculated number of hash functions (%s) was less than 1", k));
        }
        return (int)k;
    }

    private static void checkCalculatedProbability(double probability) {
        if (probability >= 1.0) {
            throw new IllegalArgumentException("Calculated probability is greater than or equal to 1: " + probability);
        }
    }

    private static int checkNumberOfBits(int numberOfBits) {
        if (numberOfBits < 1) {
            throw new IllegalArgumentException("Number of bits must be greater than 0: " + numberOfBits);
        }
        return numberOfBits;
    }

    private static int checkNumberOfHashFunctions(int numberOfHashFunctions) {
        if (numberOfHashFunctions < 1) {
            throw new IllegalArgumentException("Number of hash functions must be greater than 0: " + numberOfHashFunctions);
        }
        return numberOfHashFunctions;
    }

    private static int checkNumberOfItems(int numberOfItems) {
        if (numberOfItems < 1) {
            throw new IllegalArgumentException("Number of items must be greater than 0: " + numberOfItems);
        }
        return numberOfItems;
    }

    private static void checkProbability(double probability) {
        if (!(probability > 0.0) || !(probability < 1.0)) {
            throw new IllegalArgumentException("Probability must be greater than 0 and less than 1: " + probability);
        }
    }

    public static Shape fromKM(int numberOfHashFunctions, int numberOfBits) {
        return new Shape(numberOfHashFunctions, numberOfBits);
    }

    public static Shape fromNM(int numberOfItems, int numberOfBits) {
        Shape.checkNumberOfItems(numberOfItems);
        Shape.checkNumberOfBits(numberOfBits);
        int numberOfHashFunctions = Shape.calculateNumberOfHashFunctions(numberOfItems, numberOfBits);
        Shape shape = new Shape(numberOfHashFunctions, numberOfBits);
        Shape.checkCalculatedProbability(shape.getProbability(numberOfItems));
        return shape;
    }

    public static Shape fromNMK(int numberOfItems, int numberOfBits, int numberOfHashFunctions) {
        Shape.checkNumberOfItems(numberOfItems);
        Shape.checkNumberOfBits(numberOfBits);
        Shape.checkNumberOfHashFunctions(numberOfHashFunctions);
        Shape shape = new Shape(numberOfHashFunctions, numberOfBits);
        Shape.checkCalculatedProbability(shape.getProbability(numberOfItems));
        return shape;
    }

    public static Shape fromNP(int numberOfItems, double probability) {
        Shape.checkNumberOfItems(numberOfItems);
        Shape.checkProbability(probability);
        double m = Math.ceil((double)numberOfItems * Math.log(probability) / DENOMINATOR);
        if (m > 2.147483647E9) {
            throw new IllegalArgumentException("Resulting filter has more than 2147483647 bits: " + m);
        }
        int numberOfBits = (int)m;
        int numberOfHashFunctions = Shape.calculateNumberOfHashFunctions(numberOfItems, numberOfBits);
        Shape shape = new Shape(numberOfHashFunctions, numberOfBits);
        Shape.checkCalculatedProbability(shape.getProbability(numberOfItems));
        return shape;
    }

    public static Shape fromPMK(double probability, int numberOfBits, int numberOfHashFunctions) {
        Shape.checkProbability(probability);
        Shape.checkNumberOfBits(numberOfBits);
        Shape.checkNumberOfHashFunctions(numberOfHashFunctions);
        double n = Math.ceil((double)numberOfBits / ((double)(-numberOfHashFunctions) / Math.log(-Math.expm1(Math.log(probability) / (double)numberOfHashFunctions))));
        Shape shape = new Shape(numberOfHashFunctions, numberOfBits);
        Shape.checkCalculatedProbability(shape.getProbability((int)n));
        return shape;
    }

    private Shape(int numberOfHashFunctions, int numberOfBits) {
        this.numberOfHashFunctions = Shape.checkNumberOfHashFunctions(numberOfHashFunctions);
        this.numberOfBits = Shape.checkNumberOfBits(numberOfBits);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Shape) {
            Shape other = (Shape)obj;
            return this.numberOfBits == other.numberOfBits && this.numberOfHashFunctions == other.numberOfHashFunctions;
        }
        return false;
    }

    public double estimateMaxN() {
        return (double)this.numberOfBits * LN_2 / (double)this.numberOfHashFunctions;
    }

    public double estimateN(int cardinality) {
        double c = cardinality;
        double m = this.numberOfBits;
        double k = this.numberOfHashFunctions;
        return -(m / k) * Math.log1p(-c / m);
    }

    public int getNumberOfBits() {
        return this.numberOfBits;
    }

    public int getNumberOfHashFunctions() {
        return this.numberOfHashFunctions;
    }

    public double getProbability(int numberOfItems) {
        if (numberOfItems < 0) {
            throw new IllegalArgumentException("Number of items must be greater than or equal to 0: " + numberOfItems);
        }
        if (numberOfItems == 0) {
            return 0.0;
        }
        return Math.pow(-Math.expm1(-1.0 * (double)this.numberOfHashFunctions * (double)numberOfItems / (double)this.numberOfBits), this.numberOfHashFunctions);
    }

    public int hashCode() {
        return (31 + this.numberOfBits) * 31 + this.numberOfHashFunctions;
    }

    public boolean isSparse(int cardinality) {
        return cardinality <= BitMaps.numberOfBitMaps(this) * 2;
    }

    public String toString() {
        return String.format("Shape[k=%s m=%s]", this.numberOfHashFunctions, this.numberOfBits);
    }
}

