/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.shenyu.common.constant;

/**
 * Export/Import path constants.
 */
public final class ExportImportConstants {
    /**
     * export config file name.
     */
    public static final String EXPORT_CONFIG_FILE_NAME = "shenyu_config_export_";

    /**
     * export config file name ext.
     */
    public static final String EXPORT_CONFIG_FILE_NAME_EXT = ".zip";

    /**
     * export config file name date format.
     */
    public static final String EXPORT_CONFIG_FILE_NAME_DATE_FORMAT = "yyyyMMddHHmmss";

    /**
     * plugin json config name.
     */
    public static final String PLUGIN_JSON = "plugin.json";

    /**
     * namespace plugin json config name.
     */
    public static final String NAMESPACE_PLUGIN_JSON = "namespace_plugin.json";

    /**
     * plugin template json config name.
     */
    public static final String PLUGIN_TEMPLATE_JSON = "plugin_template.json";
    
    /**
     * plugin handle json config name.
     */
    public static final String PLUGIN_HANDLE_JSON = "plugin_handle.json";

    /**
     * selector json config name.
     */
    public static final String SELECTOR_JSON = "selector.json";

    /**
     * rule json config name.
     */
    public static final String RULE_JSON = "rule.json";

    /**
     * meta json config name.
     */
    public static final String META_JSON = "meta.json";

    /**
     * auth json config name.
     */
    public static final String AUTH_JSON = "auth.json";

    /**
     * dict json config name.
     */
    public static final String DICT_JSON = "dict.json";

    /**
     * proxy_selector json config name.
     */
    public static final String PROXY_SELECTOR_JSON = "proxy_selector.json";

    /**
     * discovery json config name.
     */
    public static final String DISCOVERY_JSON = "discovery.json";

    /**
     * discovery_upstream json config name.
     */
    public static final String DISCOVERY_UPSTREAM_JSON = "discovery_upstream.json";

    /**
     * plugin import success count.
     */
    public static final String PLUGIN_IMPORT_SUCCESS_COUNT = "pluginImportSuccessCount";

    /**
     * plugin handle import success count.
     */
    public static final String PLUGIN_HANDLE_IMPORT_SUCCESS_COUNT = "pluginHandleImportSuccessCount";

    /**
     * namespace plugin import success count.
     */
    public static final String NAMESPACE_PLUGIN_IMPORT_SUCCESS_COUNT = "namespacePluginImportSuccessCount";

    /**
     * plugin import fail message.
     */
    public static final String PLUGIN_IMPORT_FAIL_MESSAGE = "pluginImportFailMessage";

    /**
     * plugin handle import fail message.
     */
    public static final String PLUGIN_HANDLE_IMPORT_FAIL_MESSAGE = "pluginHandleImportFailMessage";

    /**
     * namespace plugin import fail message.
     */
    public static final String NAMESPACE_PLUGIN_IMPORT_FAIL_MESSAGE = "pluginHandleImportFailMessage";

    /**
     * selector import success count.
     */
    public static final String SELECTOR_IMPORT_SUCCESS_COUNT = "selectorImportSuccessCount";

    /**
     * selector import fail message.
     */
    public static final String SELECTOR_IMPORT_FAIL_MESSAGE = "selectorImportFailMessage";

    /**
     * rule import success count.
     */
    public static final String RULE_IMPORT_SUCCESS_COUNT = "ruleImportSuccessCount";

    /**
     * rule import fail message.
     */
    public static final String RULE_IMPORT_FAIL_MESSAGE = "ruleImportFailMessage";

    /**
     * dict import success count.
     */
    public static final String DICT_IMPORT_SUCCESS_COUNT = "dictImportSuccessCount";

    /**
     * dict import fail message.
     */
    public static final String DICT_IMPORT_FAIL_MESSAGE = "dictImportFailMessage";

    /**
     * proxy_selector import success count.
     */
    public static final String PROXY_SELECTOR_IMPORT_SUCCESS_COUNT = "proxySelectorImportSuccessCount";

    /**
     * proxy_selector import fail message.
     */
    public static final String PROXY_SELECTOR_IMPORT_FAIL_MESSAGE = "proxySelectorImportFailMessage";

    /**
     * discovery import success count.
     */
    public static final String DISCOVERY_IMPORT_SUCCESS_COUNT = "discoveryImportSuccessCount";

    /**
     * discovery import fail message.
     */
    public static final String DISCOVERY_IMPORT_FAIL_MESSAGE = "discoveryImportFailMessage";

    /**
     * discoveryUpstream import success count.
     */
    public static final String DISCOVERY_UPSTREAM_IMPORT_SUCCESS_COUNT = "discoveryUpstreamImportSuccessCount";

    /**
     * discoveryUpstream import fail message.
     */
    public static final String DISCOVERY_UPSTREAM_IMPORT_FAIL_MESSAGE = "discoveryUpstreamImportFailMessage";

    /**
     * auth import success count.
     */
    public static final String AUTH_IMPORT_SUCCESS_COUNT = "authImportSuccessCount";

    /**
     * auth import fail message.
     */
    public static final String AUTH_IMPORT_FAIL_MESSAGE = "authImportFailMessage";

    /**
     * meta import success count.
     */
    public static final String META_IMPORT_SUCCESS_COUNT = "metaImportSuccessCount";

    /**
     * meta import fail message.
     */
    public static final String META_IMPORT_FAIL_MESSAGE = "metaImportFailMessage";


}
