/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.io.resource.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.linkedin.util.io.resource.Resource;
import org.linkedin.util.io.resource.ResourceChain;
import org.linkedin.util.io.resource.ResourceFilter;
import org.linkedin.util.io.resource.internal.AbstractResourceProvider;
import org.linkedin.util.io.resource.internal.InternalResource;
import org.linkedin.util.io.resource.internal.InternalResourceProvider;

public class ResourceProviderChain
extends AbstractResourceProvider {
    private final List<InternalResourceProvider> _resourceProviders;

    public ResourceProviderChain(InternalResourceProvider ... resourceProviders) {
        this(Arrays.asList(resourceProviders));
    }

    public ResourceProviderChain(List<InternalResourceProvider> resourceProviders) {
        if (resourceProviders.size() == 0) {
            throw new IllegalArgumentException("list is emtpy...");
        }
        this._resourceProviders = resourceProviders;
    }

    public List<InternalResourceProvider> getResourceProviders() {
        return Collections.unmodifiableList(this._resourceProviders);
    }

    @Override
    public InternalResource doBuildResource(String path) {
        InternalResourceProvider resourceProvider;
        InternalResource resource = null;
        Iterator<InternalResourceProvider> i$ = this._resourceProviders.iterator();
        while (i$.hasNext() && !(resource = (resourceProvider = i$.next()).doBuildResource(path)).exists()) {
        }
        return new ResourceChain(this, path, resource);
    }

    @Override
    public InternalResourceProvider doCreateResourceProvider(String rootPath) {
        ArrayList<InternalResourceProvider> resourceProviders = new ArrayList<InternalResourceProvider>(this._resourceProviders.size());
        for (InternalResourceProvider resourceProvider : this._resourceProviders) {
            resourceProviders.add(resourceProvider.doCreateResourceProvider(rootPath));
        }
        return new ResourceProviderChain(resourceProviders);
    }

    @Override
    public boolean doList(String path, final ResourceFilter filter) {
        boolean isDirectory = false;
        ResourceFilter newFilter = new ResourceFilter(){

            @Override
            public boolean accept(Resource resource) {
                return filter.accept(new ResourceChain(ResourceProviderChain.this, resource.getPath(), resource));
            }
        };
        for (InternalResourceProvider resourceProvider : this._resourceProviders) {
            isDirectory |= resourceProvider.doList(path, newFilter);
        }
        return isDirectory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceProviderChain that = (ResourceProviderChain)o;
        return ((Object)this._resourceProviders).equals(that._resourceProviders);
    }

    public int hashCode() {
        return ((Object)this._resourceProviders).hashCode();
    }
}

