/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.ws;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.BrokerServiceAware;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportSupport;
import org.apache.activemq.transport.ws.WSTransport;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.wireformat.WireFormat;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WSTransportProxy
extends TransportSupport
implements Transport,
WebSocketListener,
BrokerServiceAware,
WSTransport.WSTransportSink {
    private static final Logger LOG = LoggerFactory.getLogger(WSTransportProxy.class);
    private final int ORDERLY_CLOSE_TIMEOUT = 10;
    private final ReentrantLock protocolLock = new ReentrantLock();
    private final CountDownLatch socketTransportStarted = new CountDownLatch(1);
    private final String remoteAddress;
    private final Transport transport;
    private final WSTransport wsTransport;
    private Session session;

    public WSTransportProxy(String remoteAddress, Transport transport) {
        this.remoteAddress = remoteAddress;
        this.transport = transport;
        this.wsTransport = transport.narrow(WSTransport.class);
        if (this.wsTransport == null) {
            throw new IllegalArgumentException("Provided Transport does not contains a WSTransport implementation");
        }
        this.wsTransport.setTransportSink(this);
    }

    public String getSubProtocol() {
        return this.wsTransport.getSubProtocol();
    }

    public void setTransportOptions(Map<String, Object> options) {
        Map<String, Object> wireFormatOptions = IntrospectionSupport.extractProperties(options, "wireFormat.");
        IntrospectionSupport.setProperties(this.transport, options);
        IntrospectionSupport.setProperties(this.transport.getWireFormat(), wireFormatOptions);
    }

    @Override
    public void setBrokerService(BrokerService brokerService) {
        if (this.transport instanceof BrokerServiceAware) {
            ((BrokerServiceAware)((Object)this.transport)).setBrokerService(brokerService);
        }
    }

    @Override
    public void oneway(Object command) throws IOException {
        this.protocolLock.lock();
        try {
            this.transport.oneway(command);
        }
        catch (Exception e) {
            this.onException(IOExceptionSupport.create(e));
        }
        finally {
            this.protocolLock.unlock();
        }
    }

    @Override
    public X509Certificate[] getPeerCertificates() {
        return this.transport.getPeerCertificates();
    }

    @Override
    public void setPeerCertificates(X509Certificate[] certificates) {
        this.transport.setPeerCertificates(certificates);
    }

    @Override
    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public WireFormat getWireFormat() {
        return this.transport.getWireFormat();
    }

    @Override
    public int getReceiveCounter() {
        return this.transport.getReceiveCounter();
    }

    @Override
    protected void doStop(ServiceStopper stopper) throws Exception {
        this.transport.stop();
        if (this.session != null && this.session.isOpen()) {
            this.session.close();
        }
    }

    @Override
    protected void doStart() throws Exception {
        this.socketTransportStarted.countDown();
        this.transport.setTransportListener(this.getTransportListener());
        this.transport.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWebSocketBinary(byte[] payload, int offset, int length) {
        if (!this.transportStartedAtLeastOnce()) {
            LOG.debug("Waiting for WebSocket to be properly started...");
            try {
                this.socketTransportStarted.await();
            }
            catch (InterruptedException e) {
                LOG.warn("While waiting for WebSocket to be properly started, we got interrupted!! Should be okay, but you could see race conditions...");
            }
        }
        this.protocolLock.lock();
        try {
            this.wsTransport.onWebSocketBinary(ByteBuffer.wrap(payload, offset, length));
        }
        catch (Exception e) {
            this.onException(IOExceptionSupport.create(e));
        }
        finally {
            this.protocolLock.unlock();
        }
    }

    public void onWebSocketText(String data) {
        if (!this.transportStartedAtLeastOnce()) {
            LOG.debug("Waiting for WebSocket to be properly started...");
            try {
                this.socketTransportStarted.await();
            }
            catch (InterruptedException e) {
                LOG.warn("While waiting for WebSocket to be properly started, we got interrupted!! Should be okay, but you could see race conditions...");
            }
        }
        this.protocolLock.lock();
        try {
            this.wsTransport.onWebSocketText(data);
        }
        catch (Exception e) {
            this.onException(IOExceptionSupport.create(e));
        }
        finally {
            this.protocolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWebSocketClose(int statusCode, String reason) {
        try {
            if (this.protocolLock.tryLock() || this.protocolLock.tryLock(10L, TimeUnit.SECONDS)) {
                LOG.debug("WebSocket closed: code[{}] message[{}]", (Object)statusCode, (Object)reason);
                this.wsTransport.onWebSocketClosed();
            }
        }
        catch (Exception e) {
            LOG.debug("Failed to close WebSocket cleanly", (Throwable)e);
        }
        finally {
            if (this.protocolLock.isHeldByCurrentThread()) {
                this.protocolLock.unlock();
            }
        }
    }

    public void onWebSocketConnect(Session session) {
        this.session = session;
    }

    public void onWebSocketError(Throwable cause) {
        this.onException(IOExceptionSupport.create(cause));
    }

    @Override
    public void onSocketOutboundText(String data) throws IOException {
        if (!this.transportStartedAtLeastOnce()) {
            LOG.debug("Waiting for WebSocket to be properly started...");
            try {
                this.socketTransportStarted.await();
            }
            catch (InterruptedException e) {
                LOG.warn("While waiting for WebSocket to be properly started, we got interrupted!! Should be okay, but you could see race conditions...");
            }
        }
        LOG.trace("WS Proxy sending string of size {} out", (Object)data.length());
        try {
            this.session.getRemote().sendStringByFuture(data).get(WSTransportProxy.getDefaultSendTimeOut(), TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw IOExceptionSupport.create(e);
        }
    }

    @Override
    public void onSocketOutboundBinary(ByteBuffer data) throws IOException {
        if (!this.transportStartedAtLeastOnce()) {
            LOG.debug("Waiting for WebSocket to be properly started...");
            try {
                this.socketTransportStarted.await();
            }
            catch (InterruptedException e) {
                LOG.warn("While waiting for WebSocket to be properly started, we got interrupted!! Should be okay, but you could see race conditions...");
            }
        }
        LOG.trace("WS Proxy sending {} bytes out", (Object)data.remaining());
        int limit = data.limit();
        try {
            this.session.getRemote().sendBytesByFuture(data).get(WSTransportProxy.getDefaultSendTimeOut(), TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw IOExceptionSupport.create(e);
        }
        data.limit(limit);
        data.position(limit);
    }

    private boolean transportStartedAtLeastOnce() {
        return this.socketTransportStarted.getCount() == 0L;
    }

    private static int getDefaultSendTimeOut() {
        return Integer.getInteger("org.apache.activemq.transport.ws.WSTransportProxy.sendTimeout", 30);
    }
}

