/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.tracker;

import org.ops4j.pax.web.extender.whiteboard.HttpContextMapping;
import org.ops4j.pax.web.extender.whiteboard.internal.ExtenderContext;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.AbstractHttpContextTracker;
import org.ops4j.pax.web.extender.whiteboard.runtime.DefaultHttpContextMapping;
import org.ops4j.pax.web.service.SharedWebContainerContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpContextTracker
extends AbstractHttpContextTracker<HttpContext> {
    private static final Logger LOG = LoggerFactory.getLogger(HttpContextTracker.class);

    private HttpContextTracker(ExtenderContext extenderContext, BundleContext bundleContext) {
        super(extenderContext, bundleContext);
    }

    public static ServiceTracker<HttpContext, HttpContextMapping> createTracker(ExtenderContext extenderContext, BundleContext bundleContext) {
        return new HttpContextTracker(extenderContext, bundleContext).create(HttpContext.class);
    }

    @Override
    HttpContextMapping createHttpContextMapping(ServiceReference<HttpContext> serviceReference, HttpContext published) {
        Object httpContextId = serviceReference.getProperty("httpContext.id");
        Object httpContextShared = serviceReference.getProperty("httpContext.shared");
        if (!(httpContextId == null || httpContextId instanceof String && ((String)httpContextId).trim().length() != 0)) {
            LOG.warn("Registered http context [" + published + "] did not contain a valid http context id");
            return null;
        }
        DefaultHttpContextMapping mapping = new DefaultHttpContextMapping();
        mapping.setHttpContextId((String)httpContextId);
        Boolean sharedContext = httpContextShared != null ? Boolean.valueOf((String)httpContextShared) : false;
        if (!sharedContext.booleanValue() && published instanceof SharedWebContainerContext) {
            sharedContext = true;
        } else if (sharedContext.booleanValue() && !(published instanceof SharedWebContainerContext)) {
            sharedContext = false;
        }
        mapping.setHttpContextShared(sharedContext);
        mapping.setHttpContext(published);
        return mapping;
    }
}

