/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.util.internal;

import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.util.Assert;

public class MapBasedDictionary
extends Dictionary
implements Map {
    private Map map;

    public MapBasedDictionary(Map map) {
        this.map = map == null ? new LinkedHashMap() : map;
    }

    public MapBasedDictionary() {
        this.map = new LinkedHashMap();
    }

    public MapBasedDictionary(int initialCapacity) {
        this.map = new LinkedHashMap(initialCapacity);
    }

    public MapBasedDictionary(Dictionary dictionary) {
        this(new LinkedHashMap(), dictionary);
    }

    public MapBasedDictionary(Map map, Dictionary dictionary) {
        this(map);
        if (dictionary != null) {
            this.putAll(dictionary);
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public Set entrySet() {
        return this.map.entrySet();
    }

    public Object get(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.map.get(key);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public Object put(Object key, Object value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        return this.map.put(key, value);
    }

    public void putAll(Map t) {
        this.map.putAll(t);
    }

    public void putAll(Dictionary dictionary) {
        if (dictionary != null) {
            Enumeration enm = dictionary.keys();
            while (enm.hasMoreElements()) {
                Object key = enm.nextElement();
                this.map.put(key, dictionary.get(key));
            }
        }
    }

    public Object remove(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.map.remove(key);
    }

    public int size() {
        return this.map.size();
    }

    public Collection values() {
        return this.map.values();
    }

    public Enumeration elements() {
        return new IteratorBasedEnumeration(this.map.values());
    }

    public Enumeration keys() {
        return new IteratorBasedEnumeration(this.map.keySet());
    }

    public String toString() {
        return this.map.toString();
    }

    public boolean equals(Object obj) {
        return ((Object)this.map).equals(obj);
    }

    public int hashCode() {
        return ((Object)this.map).hashCode();
    }

    private static class IteratorBasedEnumeration
    implements Enumeration {
        private Iterator it;

        public IteratorBasedEnumeration(Iterator it) {
            Assert.notNull((Object)it);
            this.it = it;
        }

        public IteratorBasedEnumeration(Collection col) {
            this(col.iterator());
        }

        public boolean hasMoreElements() {
            return this.it.hasNext();
        }

        public Object nextElement() {
            return this.it.next();
        }
    }
}

