/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.AbstractJavaCodegen;
import io.swagger.models.Info;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BaseIntegerProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.ByteArrayProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DecimalProperty;
import io.swagger.models.properties.EmailProperty;
import io.swagger.models.properties.FileProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.PasswordProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.models.properties.UUIDProperty;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApexClientCodegen
extends AbstractJavaCodegen {
    private static final String CLASS_PREFIX = "classPrefix";
    private static final String API_VERSION = "apiVersion";
    private static final String BUILD_METHOD = "buildMethod";
    private static final String NAMED_CREDENTIAL = "namedCredential";
    private static final Logger LOGGER = LoggerFactory.getLogger(ApexClientCodegen.class);
    private String classPrefix = "Swag";
    private String apiVersion = "39.0";
    private String buildMethod = "sfdx";
    private String namedCredential = this.classPrefix;
    private String srcPath = "force-app/main/default/";

    public ApexClientCodegen() {
        this.importMapping.clear();
        this.testFolder = this.sourceFolder = this.srcPath;
        this.templateDir = "apex";
        this.embeddedTemplateDir = "apex";
        this.outputFolder = "generated-code" + File.separator + "apex";
        this.apiPackage = "classes";
        this.modelPackage = "classes";
        this.testPackage = "force-app.main.default.classes";
        this.modelNamePrefix = this.classPrefix;
        this.dateLibrary = "";
        this.apiTemplateFiles.put("api.mustache", ".cls");
        this.apiTemplateFiles.put("cls-meta.mustache", ".cls-meta.xml");
        this.apiTestTemplateFiles.put("api_test.mustache", ".cls");
        this.apiTestTemplateFiles.put("cls-meta.mustache", ".cls-meta.xml");
        this.modelTemplateFiles.put("model.mustache", ".cls");
        this.modelTemplateFiles.put("cls-meta.mustache", ".cls-meta.xml");
        this.modelTestTemplateFiles.put("model_test.mustache", ".cls");
        this.modelTestTemplateFiles.put("cls-meta.mustache", ".cls-meta.xml");
        this.cliOptions.add(CliOption.newString(CLASS_PREFIX, "Prefix for generated classes. Set this to avoid overwriting existing classes in your org."));
        this.cliOptions.add(CliOption.newString(API_VERSION, "The Metadata API version number to use for components in this package."));
        this.cliOptions.add(CliOption.newString(BUILD_METHOD, "The build method for this package."));
        this.cliOptions.add(CliOption.newString(NAMED_CREDENTIAL, "The named credential name for the HTTP callouts"));
        this.supportingFiles.add(new SupportingFile("Swagger.cls", this.srcPath + "classes", "Swagger.cls"));
        this.supportingFiles.add(new SupportingFile("cls-meta.mustache", this.srcPath + "classes", "Swagger.cls-meta.xml"));
        this.supportingFiles.add(new SupportingFile("SwaggerTest.cls", this.srcPath + "classes", "SwaggerTest.cls"));
        this.supportingFiles.add(new SupportingFile("cls-meta.mustache", this.srcPath + "classes", "SwaggerTest.cls-meta.xml"));
        this.supportingFiles.add(new SupportingFile("SwaggerResponseMock.cls", this.srcPath + "classes", "SwaggerResponseMock.cls"));
        this.supportingFiles.add(new SupportingFile("cls-meta.mustache", this.srcPath + "classes", "SwaggerResponseMock.cls-meta.xml"));
        this.typeMapping.put("BigDecimal", "Double");
        this.typeMapping.put("binary", "String");
        this.typeMapping.put("ByteArray", "Blob");
        this.typeMapping.put("date", "Date");
        this.typeMapping.put("DateTime", "Datetime");
        this.typeMapping.put("file", "Blob");
        this.typeMapping.put("float", "Double");
        this.typeMapping.put("number", "Double");
        this.typeMapping.put("short", "Integer");
        this.typeMapping.put("UUID", "String");
        this.setReservedWordsLowerCase(Arrays.asList("abstract", "activate", "and", "any", "array", "as", "asc", "autonomous", "begin", "bigdecimal", "blob", "break", "bulk", "by", "byte", "case", "cast", "catch", "char", "class", "collect", "commit", "const", "continue", "convertcurrency", "date", "decimal", "default", "delete", "desc", "do", "else", "end", "enum", "exception", "exit", "export", "extends", "false", "final", "finally", "float", "for", "from", "future", "global", "goto", "group", "having", "hint", "if", "implements", "import", "inner", "insert", "instanceof", "int", "interface", "into", "join", "last_90_days", "last_month", "last_n_days", "last_week", "like", "limit", "list", "long", "loop", "map", "merge", "new", "next_90_days", "next_month", "next_n_days", "next_week", "not", "null", "nulls", "number", "object", "of", "on", "or", "outer", "override", "package", "parallel", "pragma", "private", "protected", "public", "retrieve", "return", "returning", "rollback", "savepoint", "search", "select", "set", "short", "sort", "stat", "static", "super", "switch", "synchronized", "system", "testmethod", "then", "this", "this_month", "this_week", "throw", "today", "tolabel", "tomorrow", "transaction", "trigger", "true", "try", "type", "undelete", "update", "upsert", "using", "virtual", "webservice", "when", "where", "while", "yesterday"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("Blob", "Boolean", "Date", "Datetime", "Decimal", "Double", "ID", "Integer", "Long", "Object", "String", "Time"));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(CLASS_PREFIX)) {
            this.setClassPrefix((String)this.additionalProperties.get(CLASS_PREFIX));
        }
        this.additionalProperties.put(CLASS_PREFIX, this.classPrefix);
        if (this.additionalProperties.containsKey(API_VERSION)) {
            this.setApiVersion(this.toApiVersion((String)this.additionalProperties.get(API_VERSION)));
        }
        this.additionalProperties.put(API_VERSION, this.apiVersion);
        if (this.additionalProperties.containsKey(BUILD_METHOD)) {
            this.setBuildMethod((String)this.additionalProperties.get(BUILD_METHOD));
        }
        this.additionalProperties.put(BUILD_METHOD, this.buildMethod);
        if (this.additionalProperties.containsKey(NAMED_CREDENTIAL)) {
            this.setNamedCredential((String)this.additionalProperties.get(NAMED_CREDENTIAL));
        }
        this.additionalProperties.put(NAMED_CREDENTIAL, this.namedCredential);
        this.postProcessOpts();
    }

    @Override
    public String escapeReservedWord(String name) {
        return "r" + super.escapeReservedWord(name);
    }

    @Override
    public String toModelName(String name) {
        String modelName = super.toModelName(name);
        if (modelName.length() > 36) {
            modelName = modelName.substring(0, 36);
        }
        return modelName;
    }

    @Override
    public String toDefaultValue(Property p) {
        String out = null;
        if (p instanceof ArrayProperty) {
            Property inner = ((ArrayProperty)p).getItems();
            out = String.format("new List<%s>()", inner == null ? "Object" : this.getTypeDeclaration(inner));
        } else if (p instanceof BooleanProperty) {
            out = String.valueOf(((BooleanProperty)p).getDefault());
        } else if (p instanceof LongProperty) {
            Long def = ((LongProperty)p).getDefault();
            out = def == null ? out : def.toString() + "L";
        } else if (p instanceof MapProperty) {
            Property inner = ((MapProperty)p).getAdditionalProperties();
            String s = inner == null ? "Object" : this.getTypeDeclaration(inner);
            out = String.format("new Map<String, %s>()", s);
        } else if (p instanceof StringProperty) {
            StringProperty sp = (StringProperty)p;
            String def = sp.getDefault();
            if (def != null) {
                out = sp.getEnum() == null ? String.format("'%s'", this.escapeText(def)) : def;
            }
        } else {
            out = super.toDefaultValue(p);
        }
        return "null".equals(out) ? null : out;
    }

    @Override
    public void setParameterExampleValue(CodegenParameter p) {
        if (Boolean.TRUE.equals(p.isLong)) {
            p.example = "2147483648L";
        } else if (Boolean.TRUE.equals(p.isFile)) {
            p.example = "Blob.valueOf('Sample text file\\nContents')";
        } else if (Boolean.TRUE.equals(p.isDate)) {
            p.example = "Date.newInstance(1960, 2, 17)";
        } else if (Boolean.TRUE.equals(p.isDateTime)) {
            p.example = "Datetime.newInstanceGmt(2013, 11, 12, 3, 3, 3)";
        } else if (Boolean.TRUE.equals(p.isListContainer)) {
            p.example = "new " + p.dataType + "{" + p.items.example + "}";
        } else if (Boolean.TRUE.equals(p.isMapContainer)) {
            p.example = "new " + p.dataType + "{" + p.items.example + "}";
        } else if (Boolean.TRUE.equals(p.isString)) {
            p.example = "'" + p.example + "'";
        } else if ("".equals(p.example) || p.example == null) {
            p.example = p.dataType + ".getExample()";
        }
    }

    @Override
    public CodegenModel fromModel(String name, Model model, Map<String, Model> allDefinitions) {
        CodegenModel cm = super.fromModel(name, model, allDefinitions);
        if (cm.interfaces == null) {
            cm.interfaces = new ArrayList<String>();
        }
        Boolean hasDefaultValues = false;
        ArrayList propertyMappings = new ArrayList();
        for (CodegenProperty p : cm.allVars) {
            hasDefaultValues = hasDefaultValues | p.defaultValue != null;
            if (p.baseName.equals(p.name)) continue;
            HashMap<String, String> mapping = new HashMap<String, String>();
            mapping.put("externalName", p.baseName);
            mapping.put("internalName", p.name);
            propertyMappings.add(mapping);
        }
        cm.vendorExtensions.put("hasPropertyMappings", !propertyMappings.isEmpty());
        cm.vendorExtensions.put("hasDefaultValues", hasDefaultValues);
        cm.vendorExtensions.put("propertyMappings", propertyMappings);
        if (!propertyMappings.isEmpty()) {
            cm.interfaces.add("Swagger.MappedProperties");
        }
        return cm;
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        if (parameter.isBodyParam && parameter.isListContainer) {
            parameter.items = parameter.items.items;
            this.setParameterExampleValue(parameter);
        }
    }

    @Override
    public void preprocessSwagger(Swagger swagger) {
        Info info = swagger.getInfo();
        String calloutLabel = info.getTitle();
        this.additionalProperties.put("calloutLabel", calloutLabel);
        String sanitized = this.sanitizeName(calloutLabel);
        this.additionalProperties.put("calloutName", sanitized);
        this.supportingFiles.add(new SupportingFile("namedCredential.mustache", this.srcPath + "/namedCredentials", sanitized + ".namedCredential"));
        if (this.additionalProperties.get(BUILD_METHOD).equals("sfdx")) {
            this.generateSfdxSupportingFiles();
        } else if (this.additionalProperties.get(BUILD_METHOD).equals("ant")) {
            this.generateAntSupportingFiles();
        }
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, Map<String, Model> definitions, Swagger swagger) {
        Boolean hasFormParams = false;
        for (Parameter p : operation.getParameters()) {
            if (!"formData".equals(p.getIn())) continue;
            hasFormParams = true;
            break;
        }
        operation.setConsumes(Collections.singletonList(hasFormParams != false ? "application/x-www-form-urlencoded" : "application/json"));
        operation.setProduces(Collections.singletonList("application/json"));
        CodegenOperation op = super.fromOperation(path, httpMethod, operation, definitions, swagger);
        if (op.getHasExamples()) {
            Property responseProperty = this.findMethodResponse(operation.getResponses()).getSchema();
            String deserializedExample = this.toExampleValue(responseProperty);
            for (Map<String, String> example : op.examples) {
                example.put("example", this.escapeText(example.get("example")));
                example.put("deserializedExample", deserializedExample);
            }
        }
        return op;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("'", "\\'");
    }

    public void setBuildMethod(String buildMethod) {
        this.srcPath = buildMethod.equals("ant") ? "deploy/" : "src/";
        this.testFolder = this.sourceFolder = this.srcPath;
        this.buildMethod = buildMethod;
    }

    public void setNamedCredential(String namedCredential) {
        this.namedCredential = namedCredential;
    }

    public void setClassPrefix(String classPrefix) {
        this.modelNamePrefix = classPrefix;
        this.classPrefix = classPrefix;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    private String toApiVersion(String apiVersion) {
        if (apiVersion.matches("^\\d{2}(\\.0)?$")) {
            return apiVersion.substring(0, 2) + ".0";
        }
        LOGGER.warn(String.format("specified API version is invalid: %s - defaulting to %s", apiVersion, this.apiVersion));
        return this.apiVersion;
    }

    private void postProcessOpts() {
        this.supportingFiles.add(new SupportingFile("client.mustache", this.srcPath + "classes", this.classPrefix + "Client.cls"));
        this.supportingFiles.add(new SupportingFile("cls-meta.mustache", this.srcPath + "classes", this.classPrefix + "Client.cls-meta.xml"));
    }

    @Override
    public String escapeText(String input) {
        if (input == null) {
            return input;
        }
        return input.replace("'", "\\'").replace("\n", "\\n").replace("\r", "\\r");
    }

    @Override
    public String toModelTestFilename(String name) {
        return this.toModelName(name) + "Test";
    }

    @Override
    public String toExampleValue(Property p) {
        String example;
        if (p == null) {
            return "";
        }
        Object obj = p.getExample();
        String string = example = obj == null ? "" : obj.toString();
        if (p instanceof ArrayProperty) {
            example = "new " + this.getTypeDeclaration(p) + "{" + this.toExampleValue(((ArrayProperty)p).getItems()) + "}";
        } else if (p instanceof BooleanProperty) {
            example = String.valueOf(!"false".equals(example));
        } else if (p instanceof ByteArrayProperty) {
            if (example.isEmpty()) {
                example = "VGhlIHF1aWNrIGJyb3duIGZveCBqdW1wZWQgb3ZlciB0aGUgbGF6eSBkb2cu";
            }
            ((ByteArrayProperty)p).setExample(example);
            example = "EncodingUtil.base64Decode('" + example + "')";
        } else if (p instanceof DateProperty) {
            if (example.matches("^\\d{4}(-\\d{2}){2}")) {
                example = example.substring(0, 10).replaceAll("-0?", ", ");
            } else if (example.isEmpty()) {
                example = "2000, 1, 23";
            } else {
                LOGGER.warn(String.format("The example provided for property '%s' is not a valid RFC3339 date. Defaulting to '2000-01-23'. [%s]", p.getName(), example));
                example = "2000, 1, 23";
            }
            example = "Date.newInstance(" + example + ")";
        } else if (p instanceof DateTimeProperty) {
            if (example.matches("^\\d{4}([-T:]\\d{2}){5}.+")) {
                example = example.substring(0, 19).replaceAll("[-T:]0?", ", ");
            } else if (example.isEmpty()) {
                example = "2000, 1, 23, 4, 56, 7";
            } else {
                LOGGER.warn(String.format("The example provided for property '%s' is not a valid RFC3339 datetime. Defaulting to '2000-01-23T04-56-07Z'. [%s]", p.getName(), example));
                example = "2000, 1, 23, 4, 56, 7";
            }
            example = "Datetime.newInstanceGmt(" + example + ")";
        } else if (p instanceof DecimalProperty) {
            example = (example = example.replaceAll("[^-0-9.]", "")).isEmpty() ? "1.3579" : example;
        } else if (p instanceof FileProperty) {
            if (example.isEmpty()) {
                example = "VGhlIHF1aWNrIGJyb3duIGZveCBqdW1wZWQgb3ZlciB0aGUgbGF6eSBkb2cu";
                ((FileProperty)p).setExample(example);
            }
            example = "EncodingUtil.base64Decode(" + example + ")";
        } else if (p instanceof EmailProperty) {
            if (example.isEmpty()) {
                example = "example@example.com";
                ((EmailProperty)p).setExample(example);
            }
            example = "'" + example + "'";
        } else if (p instanceof LongProperty) {
            example = example.isEmpty() ? "123456789L" : example + "L";
        } else if (p instanceof MapProperty) {
            example = "new " + this.getTypeDeclaration(p) + "{'key'=>" + this.toExampleValue(((MapProperty)p).getAdditionalProperties()) + "}";
        } else if (p instanceof ObjectProperty) {
            example = example.isEmpty() ? "null" : example;
        } else if (p instanceof PasswordProperty) {
            example = example.isEmpty() ? "password123" : this.escapeText(example);
            ((PasswordProperty)p).setExample(example);
            example = "'" + example + "'";
        } else if (p instanceof RefProperty) {
            example = this.getTypeDeclaration(p) + ".getExample()";
        } else if (p instanceof StringProperty) {
            StringProperty sp = (StringProperty)p;
            List enums = sp.getEnum();
            if (enums != null && example.isEmpty()) {
                example = (String)enums.get(0);
                sp.setExample(example);
            } else if (example.isEmpty()) {
                example = "aeiou";
            } else {
                example = this.escapeText(example);
                sp.setExample(example);
            }
            example = "'" + example + "'";
        } else if (p instanceof UUIDProperty) {
            example = example.isEmpty() ? "'046b6c7f-0b8a-43b9-b35d-6489e6daee91'" : "'" + this.escapeText(example) + "'";
        } else if (p instanceof BaseIntegerProperty) {
            example = example.matches("^-?\\d+$") ? example : "123";
        }
        return example;
    }

    @Override
    public String toApiName(String name) {
        return ApexClientCodegen.camelize(this.classPrefix + super.toApiName(name));
    }

    @Override
    public void updateCodegenPropertyEnum(CodegenProperty var) {
        super.updateCodegenPropertyEnum(var);
        if (var.isEnum && var.example != null) {
            String example = var.example.replace("'", "");
            example = this.toEnumVarName(example, var.datatype);
            var.example = this.toEnumDefaultValue(example, var.datatypeWithEnum);
        }
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "apex";
    }

    @Override
    public String getHelp() {
        return "Generates an Apex API client library (beta).";
    }

    private void generateAntSupportingFiles() {
        this.supportingFiles.add(new SupportingFile("package.mustache", "deploy", "package.xml"));
        this.supportingFiles.add(new SupportingFile("package.mustache", "undeploy", "destructiveChanges.xml"));
        this.supportingFiles.add(new SupportingFile("build.mustache", "build.xml"));
        this.supportingFiles.add(new SupportingFile("build.properties", "build.properties"));
        this.supportingFiles.add(new SupportingFile("remove.package.mustache", "undeploy", "package.xml"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.writeOptional(this.outputFolder, new SupportingFile("README_ant.mustache", "README.md"));
    }

    private void generateSfdxSupportingFiles() {
        this.supportingFiles.add(new SupportingFile("sfdx.mustache", "", "sfdx-oss-manifest.json"));
        this.writeOptional(this.outputFolder, new SupportingFile("README_sfdx.mustache", "README.md"));
    }
}

