/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.validation.skeleton.pathitem;

import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectPropertyLocation;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectType;
import org.apache.servicecomb.toolkit.oasv.validation.api.OasValidationContext;
import org.apache.servicecomb.toolkit.oasv.validation.api.OasViolation;
import org.apache.servicecomb.toolkit.oasv.validation.api.OperationValidator;
import org.apache.servicecomb.toolkit.oasv.validation.api.PathItemValidator;
import org.apache.servicecomb.toolkit.oasv.validation.util.OasObjectValidatorUtils;

public class PathItemOperationsValidator
implements PathItemValidator {
    private final List<OperationValidator> operationValidators;

    public PathItemOperationsValidator(List<OperationValidator> operationValidators) {
        this.operationValidators = operationValidators;
    }

    @Override
    public List<OasViolation> validate(OasValidationContext context, OasObjectPropertyLocation location, PathItem oasObject) {
        if (StringUtils.isNotBlank((CharSequence)oasObject.get$ref())) {
            return Collections.emptyList();
        }
        ArrayList<OasViolation> violations = new ArrayList<OasViolation>();
        Map operationMap = oasObject.readOperationsMap();
        for (Map.Entry entry : operationMap.entrySet()) {
            PathItem.HttpMethod method = (PathItem.HttpMethod)entry.getKey();
            Operation operation = (Operation)entry.getValue();
            OasObjectPropertyLocation operationLocation = location.property(method.toString().toLowerCase(), OasObjectType.OPERATION);
            violations.addAll(OasObjectValidatorUtils.doValidateProperty(context, operationLocation, operation, this.operationValidators));
        }
        return violations;
    }
}

