/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.diffvalidation.api;

import java.util.List;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectPropertyLocation;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectType;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.OasDiffValidationContext;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.OasDiffViolation;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.OasObjectDiffValidator;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.api.OasObjectDiffValidatorTemplate;
import org.apache.servicecomb.toolkit.oasv.diffvalidation.util.OasObjectDiffValidatorUtils;

public abstract class ObjectPropertyDiffValidator<T, P>
extends OasObjectDiffValidatorTemplate<T> {
    private final List<? extends OasObjectDiffValidator<P>> diffValidators;

    protected ObjectPropertyDiffValidator(List<? extends OasObjectDiffValidator<P>> diffValidators) {
        this.diffValidators = diffValidators;
    }

    @Override
    protected List<OasDiffViolation> validateCompare(OasDiffValidationContext context, OasObjectPropertyLocation leftLocation, T leftOasObject, OasObjectPropertyLocation rightLocation, T rightOasObject) {
        P leftProperty = this.getPropertyObject(leftOasObject);
        P rightProperty = this.getPropertyObject(rightOasObject);
        OasObjectPropertyLocation leftPropertyLoc = leftProperty == null ? null : leftLocation.property(this.getPropertyName(), this.getPropertyType());
        OasObjectPropertyLocation rightPropertyLoc = rightProperty == null ? null : rightLocation.property(this.getPropertyName(), this.getPropertyType());
        return OasObjectDiffValidatorUtils.doDiffValidateProperty(context, leftPropertyLoc, leftProperty, rightPropertyLoc, rightProperty, this.diffValidators);
    }

    protected abstract P getPropertyObject(T var1);

    protected abstract String getPropertyName();

    protected abstract OasObjectType getPropertyType();
}

