/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.style.validator.operation;

import io.swagger.v3.oas.models.Operation;
import java.util.Collections;
import java.util.List;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectPropertyLocation;
import org.apache.servicecomb.toolkit.oasv.util.StringCaseUtils;
import org.apache.servicecomb.toolkit.oasv.validation.api.OasValidationContext;
import org.apache.servicecomb.toolkit.oasv.validation.api.OasViolation;
import org.apache.servicecomb.toolkit.oasv.validation.api.OperationValidator;

public class OperationIdCaseValidator
implements OperationValidator {
    public static final String CONFIG_KEY = "operation.operationId.case";
    public static final String ERROR = "Must be ";
    private final String expectedCase;

    public OperationIdCaseValidator(String expectedCase) {
        this.expectedCase = expectedCase;
    }

    public List<OasViolation> validate(OasValidationContext context, OasObjectPropertyLocation location, Operation oasObject) {
        if (!StringCaseUtils.isMatchCase((String)this.expectedCase, (String)oasObject.getOperationId())) {
            return Collections.singletonList(new OasViolation(location.property("operationId"), ERROR + this.expectedCase));
        }
        return Collections.emptyList();
    }
}

