/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.generator.util;

import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Encoding;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class SwaggerAnnotationUtils {
    public static List<Content> getContentFromAnnotation(io.swagger.v3.oas.annotations.media.Content ... contentAnnotations) {
        if (contentAnnotations == null || contentAnnotations.length < 1) {
            return null;
        }
        ArrayList<Content> contents = new ArrayList<Content>();
        for (io.swagger.v3.oas.annotations.media.Content contentAnnotation : contentAnnotations) {
            Content content = new Content();
            MediaType mediaType = new MediaType();
            Encoding[] encodingAnnotations = contentAnnotation.encoding();
            Optional.ofNullable(encodingAnnotations).ifPresent(encodings -> {
                for (Encoding encodingAnnotation : encodings) {
                    io.swagger.v3.oas.models.media.Encoding encoding = new io.swagger.v3.oas.models.media.Encoding();
                    encoding.contentType(encodingAnnotation.contentType());
                    encoding.allowReserved(Boolean.valueOf(encodingAnnotation.allowReserved()));
                    encoding.explode(Boolean.valueOf(encodingAnnotation.explode()));
                    mediaType.addEncoding(encodingAnnotation.name(), encoding);
                }
            });
            content.addMediaType(contentAnnotation.mediaType(), mediaType);
            contents.add(content);
        }
        return contents;
    }

    public static io.swagger.v3.oas.models.media.Schema getSchemaFromAnnotation(Schema schema) {
        if (schema == null) {
            return null;
        }
        io.swagger.v3.oas.models.media.Schema schemaObj = new io.swagger.v3.oas.models.media.Schema();
        schemaObj.setName(schema.name());
        schemaObj.setDescription(schema.description());
        schemaObj.setType(schema.type());
        schemaObj.setTitle(schema.title());
        schemaObj.setNullable(Boolean.valueOf(schema.nullable()));
        schemaObj.setDefault((Object)schema.defaultValue());
        schemaObj.setFormat(schema.format());
        schemaObj.setDeprecated(Boolean.valueOf(schema.deprecated()));
        Map<String, Object> extensionsFromAnnotation = SwaggerAnnotationUtils.getExtensionsFromAnnotation(schema.extensions());
        schemaObj.extensions(extensionsFromAnnotation);
        return schemaObj;
    }

    public static Map<String, Object> getExtensionsFromAnnotation(Extension ... extensions) {
        if (extensions == null || extensions.length < 1) {
            return null;
        }
        HashMap<String, Object> extensionMap = new HashMap<String, Object>();
        for (Extension extension : extensions) {
            ExtensionProperty[] properties = extension.properties();
            Optional.ofNullable(properties).ifPresent(props -> {
                for (ExtensionProperty prop : props) {
                    extensionMap.put(prop.name(), prop.value());
                }
            });
        }
        return extensionMap;
    }
}

