/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.generator.parser;

import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.toolkit.generator.annotation.ApiResponseMethodAnnotationProcessor;
import org.apache.servicecomb.toolkit.generator.annotation.ApiResponsesMethodAnnotationProcessor;
import org.apache.servicecomb.toolkit.generator.annotation.ClassAnnotationProcessor;
import org.apache.servicecomb.toolkit.generator.annotation.MethodAnnotationProcessor;
import org.apache.servicecomb.toolkit.generator.annotation.OpenApiDefinitionClassAnnotationProcessor;
import org.apache.servicecomb.toolkit.generator.annotation.OperationMethodAnnotationProcessor;
import org.apache.servicecomb.toolkit.generator.annotation.ParamAnnotationProcessor;
import org.apache.servicecomb.toolkit.generator.annotation.ParameterAnnotationProcessor;
import org.apache.servicecomb.toolkit.generator.annotation.RequestBodyParamAnnotationProcessor;
import org.apache.servicecomb.toolkit.generator.context.OasContext;
import org.apache.servicecomb.toolkit.generator.context.OperationContext;
import org.apache.servicecomb.toolkit.generator.context.ParameterContext;
import org.apache.servicecomb.toolkit.generator.parser.api.OpenApiAnnotationParser;

public abstract class AbstractAnnotationParser
implements OpenApiAnnotationParser {
    private Class<?> cls;
    private OasContext context;
    protected Map<Class<? extends Annotation>, ClassAnnotationProcessor> classAnnotationMap = new HashMap<Class<? extends Annotation>, ClassAnnotationProcessor>();
    protected Map<Class<? extends Annotation>, MethodAnnotationProcessor> methodAnnotationMap = new HashMap<Class<? extends Annotation>, MethodAnnotationProcessor>();
    protected Map<Class<? extends Annotation>, ParamAnnotationProcessor> parameterAnnotationMap = new HashMap<Class<? extends Annotation>, ParamAnnotationProcessor>();

    public AbstractAnnotationParser() {
        this.initMethodAnnotationProcessor();
        this.initClassAnnotationProcessor();
        this.initParameterAnnotationProcessor();
    }

    @Override
    public void parser(Class<?> cls, OasContext context) {
        this.cls = cls;
        this.context = context;
        if (!this.canProcess(cls)) {
            return;
        }
        for (Annotation clsAnnotation : cls.getAnnotations()) {
            Annotation[] annotationProcessor = (Annotation[])this.classAnnotationMap.get(clsAnnotation.annotationType());
            if (annotationProcessor == null) continue;
            annotationProcessor.process(clsAnnotation, context);
        }
        this.postParseClassAnnotaion(context);
        List<Method> methods = Arrays.asList(cls.getDeclaredMethods());
        methods.sort(Comparator.comparing(Method::getName));
        for (Method m : methods) {
            java.lang.reflect.Parameter[] parameters;
            OperationContext operationContext = new OperationContext(m, context);
            for (Annotation methodAnnotation : m.getAnnotations()) {
                MethodAnnotationProcessor annotationProcessor = this.methodAnnotationMap.get(methodAnnotation.annotationType());
                if (annotationProcessor == null) continue;
                annotationProcessor.process(methodAnnotation, operationContext);
            }
            this.postParseMethodAnnotation(operationContext);
            for (java.lang.reflect.Parameter parameter : parameters = m.getParameters()) {
                ParameterContext parameterContext = new ParameterContext(operationContext, parameter);
                for (Annotation paramAnnotation : parameter.getAnnotations()) {
                    ParamAnnotationProcessor paramAnnotationProcessor = this.parameterAnnotationMap.get(paramAnnotation.annotationType());
                    if (paramAnnotationProcessor == null) continue;
                    paramAnnotationProcessor.process(paramAnnotation, parameterContext);
                }
                this.postParseParameterAnnotation(parameterContext);
            }
        }
    }

    @Override
    public void postParseClassAnnotaion(OasContext context) {
    }

    @Override
    public void postParseMethodAnnotation(OperationContext context) {
    }

    @Override
    public void postParseParameterAnnotation(ParameterContext context) {
    }

    public void initMethodAnnotationProcessor() {
        this.methodAnnotationMap.put(Operation.class, new OperationMethodAnnotationProcessor());
        this.methodAnnotationMap.put(ApiResponse.class, new ApiResponseMethodAnnotationProcessor());
        this.methodAnnotationMap.put(ApiResponses.class, new ApiResponsesMethodAnnotationProcessor());
    }

    public void initClassAnnotationProcessor() {
        this.classAnnotationMap.put(OpenAPIDefinition.class, new OpenApiDefinitionClassAnnotationProcessor());
    }

    public void initParameterAnnotationProcessor() {
        this.parameterAnnotationMap.put(Parameter.class, new ParameterAnnotationProcessor());
        this.parameterAnnotationMap.put(RequestBody.class, new RequestBodyParamAnnotationProcessor());
    }

    @Override
    public ClassAnnotationProcessor findClassAnnotationProcessor(Class<? extends Annotation> annotationType) {
        return this.classAnnotationMap.get(annotationType);
    }

    @Override
    public MethodAnnotationProcessor findMethodAnnotationProcessor(Class<? extends Annotation> annotationType) {
        return this.methodAnnotationMap.get(annotationType);
    }

    @Override
    public ParamAnnotationProcessor findParameterAnnotationProcessor(Class<? extends Annotation> annotationType) {
        return this.parameterAnnotationMap.get(annotationType);
    }
}

