/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.generator.context;

import io.swagger.v3.oas.models.OpenAPI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.servicecomb.toolkit.generator.context.OasContext;
import org.apache.servicecomb.toolkit.generator.parser.api.OpenApiAnnotationParser;

public class OasGenerator {
    private static List<OpenApiAnnotationParser> parserList = new ArrayList<OpenApiAnnotationParser>();

    public OpenAPI generate(Class<?> cls) {
        Optional<OpenApiAnnotationParser> parserOptional = parserList.stream().filter(parser -> parser.canProcess(cls)).findFirst();
        if (!parserOptional.isPresent()) {
            return null;
        }
        OasContext context = new OasContext(parserOptional.get());
        parserOptional.get().parser(cls, context);
        return context.toOpenAPI();
    }

    public List<OpenAPI> generate(Set<Class> classes) {
        ArrayList<OpenAPI> openApiList = new ArrayList<OpenAPI>();
        for (Class cls : classes) {
            OpenAPI openAPI = this.generate(cls);
            if (openAPI == null) continue;
            openApiList.add(openAPI);
        }
        return openApiList;
    }

    static {
        ServiceLoader.load(OpenApiAnnotationParser.class).forEach(parserList::add);
        parserList.sort(Comparator.comparingInt(OpenApiAnnotationParser::getOrder));
    }
}

