/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.provider.rest.common;

import io.vertx.core.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.common.rest.definition.RestOperationMeta;
import org.apache.servicecomb.common.rest.definition.RestParam;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.foundation.common.exceptions.ServiceCombException;
import org.apache.servicecomb.foundation.vertx.http.AbstractHttpServletRequest;

public class InvocationToHttpServletRequest
extends AbstractHttpServletRequest {
    private RestOperationMeta swaggerOperation;
    private Object[] args;
    private SocketAddress sockerAddress;

    public InvocationToHttpServletRequest(Invocation invocation) {
        this.swaggerOperation = (RestOperationMeta)invocation.getOperationMeta().getExtData("swaggerRestOperation");
        this.args = invocation.getArgs();
        this.sockerAddress = (SocketAddress)invocation.getHandlerContext().get("x-cse-remote-address");
    }

    public String getParameter(String name) {
        RestParam param = this.swaggerOperation.getParamByName(name);
        if (param == null) {
            return null;
        }
        Object value = param.getValue(this.args);
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    public String[] getParameterValues(String name) {
        RestParam param = this.swaggerOperation.getParamByName(name);
        if (param == null) {
            return null;
        }
        return param.getValueAsStrings(this.args);
    }

    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> paramMap = new HashMap<String, String[]>();
        for (RestParam param : this.swaggerOperation.getParamList()) {
            String[] value = param.getValueAsStrings(this.args);
            paramMap.put(param.getParamName(), value);
        }
        return paramMap;
    }

    public String getHeader(String name) {
        return this.getParameter(name);
    }

    public int getIntHeader(String name) {
        String header = this.getHeader(name);
        if (header == null) {
            return -1;
        }
        return Integer.parseInt(header);
    }

    public String getMethod() {
        return this.swaggerOperation.getHttpMethod();
    }

    public String getPathInfo() {
        try {
            return this.swaggerOperation.getPathBuilder().createPathString(this.args);
        }
        catch (Exception e) {
            throw new ServiceCombException("Failed to get path info.", (Throwable)e);
        }
    }

    public String getRemoteAddr() {
        return this.sockerAddress == null ? "" : this.sockerAddress.host();
    }

    public String getRemoteHost() {
        return this.sockerAddress == null ? "" : this.sockerAddress.host();
    }

    public int getRemotePort() {
        return this.sockerAddress == null ? 0 : this.sockerAddress.port();
    }

    public String getContextPath() {
        return "";
    }

    public String getContentType() {
        return null;
    }

    public String getCharacterEncoding() {
        return null;
    }
}

