/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.common.util;

import org.apache.commons.lang3.StringUtils;

public class NamespaceUtil {
    public static final String NAMESPACE_SPLITER = "%";
    private static final int RESOURCE_LENGTH = 2;
    public static final String MQ_DEFAULT_NAMESPACE_NAME = "DEFAULT_INSTANCE";

    public static String encodeToNamespaceResource(String namespace, String resource) {
        return resource != null && namespace != null ? StringUtils.join((Object[])new String[]{namespace, NAMESPACE_SPLITER, resource}) : resource;
    }

    public static String decodeOriginResource(String resource) {
        if (resource != null && resource.contains(NAMESPACE_SPLITER)) {
            int firstIndex = resource.indexOf(NAMESPACE_SPLITER);
            return resource.substring(firstIndex + 1);
        }
        return resource;
    }

    public static String decodeMqttNamespaceIdFromKey(String key) {
        return NamespaceUtil.decodeMqttNamespaceIdFromClientId(key);
    }

    public static String decodeMqttNamespaceIdFromClientId(String clientId) {
        return NamespaceUtil.splitNamespaceStr(clientId);
    }

    public static String decodeStoreNamespaceIdFromTopic(String topic) {
        return NamespaceUtil.splitNamespaceStr(topic);
    }

    public static String decodeNamespaceId(String resource) {
        return NamespaceUtil.splitNamespaceStr(resource);
    }

    private static String splitNamespaceStr(String namespaceStr) {
        return namespaceStr != null && namespaceStr.contains(NAMESPACE_SPLITER) ? namespaceStr.split(NAMESPACE_SPLITER)[0] : null;
    }
}

