/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.cs.session.loop;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.mqtt.common.facade.LmqOffsetStore;
import org.apache.rocketmq.mqtt.common.facade.LmqQueueStore;
import org.apache.rocketmq.mqtt.common.facade.SubscriptionPersistManager;
import org.apache.rocketmq.mqtt.common.facade.WillMsgPersistManager;
import org.apache.rocketmq.mqtt.common.meta.IpUtil;
import org.apache.rocketmq.mqtt.common.model.PullResult;
import org.apache.rocketmq.mqtt.common.model.Queue;
import org.apache.rocketmq.mqtt.common.model.QueueOffset;
import org.apache.rocketmq.mqtt.common.model.Subscription;
import org.apache.rocketmq.mqtt.common.model.WillMessage;
import org.apache.rocketmq.mqtt.common.util.SpringUtils;
import org.apache.rocketmq.mqtt.cs.channel.ChannelInfo;
import org.apache.rocketmq.mqtt.cs.channel.ChannelManager;
import org.apache.rocketmq.mqtt.cs.config.ConnectConf;
import org.apache.rocketmq.mqtt.cs.session.QueueFresh;
import org.apache.rocketmq.mqtt.cs.session.Session;
import org.apache.rocketmq.mqtt.cs.session.infly.InFlyCache;
import org.apache.rocketmq.mqtt.cs.session.infly.MqttMsgId;
import org.apache.rocketmq.mqtt.cs.session.infly.PushAction;
import org.apache.rocketmq.mqtt.cs.session.loop.PullResultStatus;
import org.apache.rocketmq.mqtt.cs.session.loop.QueueCache;
import org.apache.rocketmq.mqtt.cs.session.loop.SessionLoop;
import org.apache.rocketmq.mqtt.cs.session.match.MatchAction;
import org.apache.rocketmq.mqtt.ds.upstream.processor.PublishProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SessionLoopImpl
implements SessionLoop {
    private static Logger logger = LoggerFactory.getLogger(SessionLoopImpl.class);
    @Resource
    private PushAction pushAction;
    @Resource
    private MatchAction matchAction;
    @Resource
    private ConnectConf connectConf;
    @Resource
    private InFlyCache inFlyCache;
    @Resource
    private QueueCache queueCache;
    @Resource
    private LmqQueueStore lmqQueueStore;
    @Resource
    private LmqOffsetStore lmqOffsetStore;
    @Resource
    private QueueFresh queueFresh;
    @Resource
    private WillMsgPersistManager willMsgPersistManager;
    @Resource
    private MqttMsgId mqttMsgId;
    @Resource
    private PublishProcessor publishProcessor;
    private ChannelManager channelManager;
    private ScheduledThreadPoolExecutor pullService;
    private ScheduledThreadPoolExecutor scheduler;
    private ScheduledThreadPoolExecutor persistOffsetScheduler;
    private SubscriptionPersistManager subscriptionPersistManager;
    private Map<String, Session> sessionMap = new ConcurrentHashMap<String, Session>(1024);
    private Map<String, Map<String, Session>> clientMap = new ConcurrentHashMap<String, Map<String, Session>>(1024);
    private Map<String, PullEvent> pullEventMap = new ConcurrentHashMap<String, PullEvent>(1024);
    private Map<String, Boolean> pullStatus = new ConcurrentHashMap<String, Boolean>(1024);
    private AtomicLong rid = new AtomicLong();
    private long pullIntervalMillis = 10L;

    @PostConstruct
    public void init() {
        this.pullService = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new ThreadFactoryImpl("pull_message_thread_"));
        this.scheduler = new ScheduledThreadPoolExecutor(2, (ThreadFactory)new ThreadFactoryImpl("loop_scheduler_"));
        this.persistOffsetScheduler = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new ThreadFactoryImpl("persistOffset_scheduler_"));
        this.persistOffsetScheduler.scheduleWithFixedDelay(() -> this.persistAllOffset(true), 5000L, 5000L, TimeUnit.MILLISECONDS);
        this.pullService.scheduleWithFixedDelay(() -> this.pullLoop(), this.pullIntervalMillis, this.pullIntervalMillis, TimeUnit.MILLISECONDS);
    }

    private void pullLoop() {
        try {
            for (Map.Entry<String, PullEvent> entry : this.pullEventMap.entrySet()) {
                PullEvent pullEvent = entry.getValue();
                Session session = pullEvent.session;
                if (!session.getChannel().isActive()) {
                    this.pullStatus.remove(this.eventQueueKey(session, pullEvent.queue));
                    this.pullEventMap.remove(entry.getKey());
                    continue;
                }
                if (Boolean.TRUE.equals(this.pullStatus.get(this.eventQueueKey(session, pullEvent.queue))) || !session.getChannel().isWritable()) continue;
                this.doPull(pullEvent);
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }

    @Override
    public void setChannelManager(ChannelManager channelManager) {
        this.channelManager = channelManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadSession(String clientId, Channel channel) {
        if (StringUtils.isBlank((CharSequence)clientId)) {
            return;
        }
        if (!channel.isActive()) {
            return;
        }
        String channelId = ChannelInfo.getId(channel);
        if (this.sessionMap.containsKey(channelId)) {
            return;
        }
        Session session = new Session();
        session.setClientId(clientId);
        session.setChannelId(channelId);
        session.setChannel(channel);
        this.addSubscriptionAndInit(session, new HashSet<Subscription>(Arrays.asList(Subscription.newP2pSubscription((String)clientId), Subscription.newRetrySubscription((String)clientId))), ChannelInfo.getFuture(channel, "connect"));
        SessionLoopImpl sessionLoopImpl = this;
        synchronized (sessionLoopImpl) {
            this.sessionMap.put(channelId, session);
            if (!this.clientMap.containsKey(clientId)) {
                this.clientMap.putIfAbsent(clientId, new ConcurrentHashMap(2));
            }
            this.clientMap.get(clientId).put(channelId, session);
        }
        if (!channel.isActive()) {
            this.unloadSession(clientId, channelId);
            return;
        }
        if (!session.isClean()) {
            this.notifyPullMessage(session, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session unloadSession(String clientId, String channelId) {
        Session session = null;
        try {
            SessionLoopImpl sessionLoopImpl = this;
            synchronized (sessionLoopImpl) {
                session = this.sessionMap.remove(channelId);
                if (clientId == null && session != null) {
                    clientId = session.getClientId();
                }
                if (clientId != null && this.clientMap.containsKey(clientId)) {
                    this.clientMap.get(clientId).remove(channelId);
                    if (this.clientMap.get(clientId).isEmpty()) {
                        this.clientMap.remove(clientId);
                    }
                }
            }
            this.inFlyCache.cleanResource(clientId, channelId);
            if (session != null) {
                this.matchAction.removeSubscription(session, session.subscriptionSnapshot());
                this.persistOffset(session);
            }
        }
        catch (Exception e) {
            logger.error("unloadSession fail:{},{}", new Object[]{clientId, channelId, e});
        }
        finally {
            if (session != null) {
                session.destroy();
            }
        }
        return session;
    }

    @Override
    public Session getSession(String channelId) {
        return this.sessionMap.get(channelId);
    }

    @Override
    public List<Session> getSessionList(String clientId) {
        ArrayList<Session> list = new ArrayList<Session>();
        Map<String, Session> sessions = this.clientMap.get(clientId);
        if (sessions != null && !sessions.isEmpty()) {
            for (Session session : sessions.values()) {
                if (!session.isDestroyed()) {
                    list.add(session);
                    continue;
                }
                logger.error("the session was destroyed,{}", (Object)clientId);
                sessions.remove(session.getChannelId());
            }
        }
        return list;
    }

    @Override
    public void addSubscription(String channelId, Set<Subscription> subscriptions) {
        if (subscriptions == null || subscriptions.isEmpty()) {
            return;
        }
        Session session = this.getSession(channelId);
        if (session == null) {
            return;
        }
        this.addSubscriptionAndInit(session, subscriptions, ChannelInfo.getFuture(session.getChannel(), "subscribe"));
        this.matchAction.addSubscription(session, subscriptions);
        if (!session.isClean()) {
            for (Subscription subscription : subscriptions) {
                this.notifyPullMessage(session, subscription, null);
            }
        }
    }

    @Override
    public void removeSubscription(String channelId, Set<Subscription> subscriptions) {
        if (subscriptions == null || subscriptions.isEmpty()) {
            return;
        }
        Session session = this.getSession(channelId);
        if (session == null) {
            return;
        }
        for (Subscription subscription : subscriptions) {
            session.removeSubscription(subscription);
        }
        this.matchAction.removeSubscription(session, subscriptions);
    }

    private void addSubscriptionAndInit(Session session, Set<Subscription> subscriptions, CompletableFuture<Void> future) {
        Map<Queue, QueueOffset> queueOffsets;
        if (session == null) {
            return;
        }
        if (subscriptions == null) {
            return;
        }
        session.addSubscription(subscriptions);
        AtomicInteger result = new AtomicInteger(0);
        for (Subscription subscription : subscriptions) {
            this.queueFresh.freshQueue(session, subscription);
            queueOffsets = session.getQueueOffset(subscription);
            if (queueOffsets == null) continue;
            result.addAndGet(queueOffsets.size());
        }
        for (Subscription subscription : subscriptions) {
            queueOffsets = session.getQueueOffset(subscription);
            if (queueOffsets == null) continue;
            for (Map.Entry<Queue, QueueOffset> entry : queueOffsets.entrySet()) {
                this.initOffset(session, subscription, entry.getKey(), entry.getValue(), future, result);
            }
        }
    }

    private void futureDone(CompletableFuture<Void> future, AtomicInteger result) {
        if (future == null) {
            return;
        }
        if (result == null) {
            return;
        }
        if (result.decrementAndGet() <= 0) {
            future.complete(null);
        }
    }

    private void initOffset(Session session, Subscription subscription, Queue queue, QueueOffset queueOffset, CompletableFuture<Void> future, AtomicInteger result) {
        if (queueOffset.isInitialized()) {
            this.futureDone(future, result);
            return;
        }
        if (queueOffset.isInitializing()) {
            return;
        }
        queueOffset.setInitializing();
        CompletableFuture queryResult = this.lmqQueueStore.queryQueueMaxOffset(queue);
        queryResult.whenComplete((maxOffset, throwable) -> {
            if (throwable != null) {
                logger.error("queryQueueMaxId onException {}", (Object)queue.getQueueName(), throwable);
                QueueOffset thisQueueOffset = session.getQueueOffset(subscription, queue);
                if (thisQueueOffset != null) {
                    if (!thisQueueOffset.isInitialized()) {
                        thisQueueOffset.setOffset(Long.MAX_VALUE);
                    }
                    thisQueueOffset.setInitialized();
                }
                this.futureDone(future, result);
                return;
            }
            QueueOffset thisQueueOffset = session.getQueueOffset(subscription, queue);
            if (thisQueueOffset != null) {
                if (!thisQueueOffset.isInitialized()) {
                    thisQueueOffset.setOffset(maxOffset.longValue());
                }
                thisQueueOffset.setInitialized();
            }
            this.futureDone(future, result);
        });
    }

    @Override
    public void notifyPullMessage(Session session, Subscription subscription, Queue queue) {
        if (session == null || session.isDestroyed()) {
            return;
        }
        if (this.subscriptionPersistManager == null) {
            this.subscriptionPersistManager = (SubscriptionPersistManager)SpringUtils.getBean(SubscriptionPersistManager.class);
        }
        if (this.subscriptionPersistManager != null && !session.isClean() && !session.isLoaded()) {
            if (session.isLoading()) {
                return;
            }
            session.setLoading();
            CompletableFuture future = this.subscriptionPersistManager.loadSubscriptions(session.getClientId());
            future.whenComplete((subscriptions, throwable) -> {
                if (throwable != null) {
                    logger.error("", throwable);
                    this.scheduler.schedule(() -> {
                        session.resetLoad();
                        this.notifyPullMessage(session, subscription, queue);
                    }, 3L, TimeUnit.SECONDS);
                    return;
                }
                session.addSubscription((Set<Subscription>)subscriptions);
                this.matchAction.addSubscription(session, (Set<Subscription>)subscriptions);
                session.setLoaded();
                this.notifyPullMessage(session, subscription, queue);
            });
            return;
        }
        if (queue != null) {
            if (subscription == null) {
                throw new RuntimeException("invalid notifyPullMessage, subscription is null, but queue is not null," + session.getClientId());
            }
            this.queueFresh.freshQueue(session, subscription);
            this.pullMessage(session, subscription, queue);
            return;
        }
        for (Subscription each : session.subscriptionSnapshot()) {
            if (subscription != null && !each.equals((Object)subscription)) continue;
            this.queueFresh.freshQueue(session, each);
            Map<Queue, QueueOffset> queueOffsets = session.getQueueOffset(each);
            if (queueOffsets == null) continue;
            for (Map.Entry<Queue, QueueOffset> entry : queueOffsets.entrySet()) {
                this.pullMessage(session, each, entry.getKey());
            }
        }
    }

    @Override
    public void addWillMessage(Channel channel, WillMessage willMessage) {
        Session session = this.getSession(ChannelInfo.getId(channel));
        String clientId = ChannelInfo.getClientId(channel);
        String ip = IpUtil.getLocalAddressCompatible();
        if (session == null) {
            return;
        }
        if (willMessage == null) {
            return;
        }
        String message = JSON.toJSONString((Object)willMessage);
        String willKey = ip + 1 + clientId;
        this.willMsgPersistManager.put(willKey, message).whenComplete((result, throwable) -> {
            if (!result.booleanValue() || throwable != null) {
                logger.error("fail to put will message key {} value {}", (Object)willKey, (Object)willMessage);
                return;
            }
            logger.debug("put will message key {} value {} successfully", (Object)willKey, (Object)message);
        });
    }

    private String eventQueueKey(Session session, Queue queue) {
        StringBuilder sb = new StringBuilder();
        sb.append(ChannelInfo.getId(session.getChannel()));
        sb.append("-");
        sb.append(queue.getQueueId());
        sb.append("-");
        sb.append(queue.getQueueName());
        sb.append("-");
        sb.append(queue.getBrokerName());
        return sb.toString();
    }

    private boolean needLoadPersistedOffset(Session session, Subscription subscription, Queue queue) {
        if (session.isClean()) {
            return false;
        }
        Integer status = (Integer)session.getLoadStatusMap().get(subscription);
        if (status != null && status == 1) {
            return false;
        }
        if (status != null && status == 0) {
            return true;
        }
        session.getLoadStatusMap().put(subscription, 0);
        CompletableFuture result = this.lmqOffsetStore.getOffset(session.getClientId(), subscription);
        result.whenComplete((offsetMap, throwable) -> {
            if (throwable != null) {
                this.scheduler.schedule(() -> {
                    session.getLoadStatusMap().put(subscription, -1);
                    this.pullMessage(session, subscription, queue);
                }, 3L, TimeUnit.SECONDS);
                return;
            }
            session.addOffset(subscription.toQueueName(), (Map<Queue, QueueOffset>)offsetMap);
            session.getLoadStatusMap().put(subscription, 1);
            this.pullMessage(session, subscription, queue);
        });
        return true;
    }

    private void pullMessage(Session session, Subscription subscription, Queue queue) {
        if (queue == null) {
            return;
        }
        if (session == null || session.isDestroyed()) {
            return;
        }
        if (this.needLoadPersistedOffset(session, subscription, queue)) {
            return;
        }
        if (!session.sendingMessageIsEmpty(subscription, queue)) {
            this.scheduler.schedule(() -> this.pullMessage(session, subscription, queue), this.pullIntervalMillis, TimeUnit.MILLISECONDS);
        } else {
            PullEvent pullEvent = new PullEvent(session, subscription, queue);
            this.pullEventMap.put(this.eventQueueKey(session, queue), pullEvent);
        }
    }

    private void doPull(PullEvent pullEvent) {
        Session session = pullEvent.session;
        Subscription subscription = pullEvent.subscription;
        Queue queue = pullEvent.queue;
        QueueOffset queueOffset = session.getQueueOffset(subscription, queue);
        if (session.isDestroyed() || queueOffset == null) {
            this.clearPullStatus(session, queue, pullEvent);
            return;
        }
        if (!queueOffset.isInitialized()) {
            this.initOffset(session, subscription, queue, queueOffset, null, null);
            this.scheduler.schedule(() -> this.pullMessage(session, subscription, queue), this.pullIntervalMillis, TimeUnit.MILLISECONDS);
            return;
        }
        this.pullStatus.put(this.eventQueueKey(session, queue), true);
        int count = session.getPullSize() > 0 ? session.getPullSize() : this.connectConf.getPullBatchSize();
        CompletableFuture<PullResult> result = new CompletableFuture<PullResult>();
        result.whenComplete((pullResult, throwable) -> {
            if (throwable != null) {
                this.clearPullStatus(session, queue, pullEvent);
                logger.error("{}", (Object)session.getClientId(), throwable);
                if (session.isDestroyed()) {
                    return;
                }
                this.scheduler.schedule(() -> this.pullMessage(session, subscription, queue), 1L, TimeUnit.SECONDS);
                return;
            }
            try {
                if (session.isDestroyed()) {
                    return;
                }
                if (301 == pullResult.getCode()) {
                    boolean add;
                    if (pullResult.getMessageList() != null && pullResult.getMessageList().size() >= count) {
                        this.scheduler.schedule(() -> this.pullMessage(session, subscription, queue), this.pullIntervalMillis, TimeUnit.MILLISECONDS);
                    }
                    if (add = session.addSendingMessages(subscription, queue, pullResult.getMessageList())) {
                        this.pushAction.messageArrive(session, subscription, queue);
                    }
                } else if (302 == pullResult.getCode()) {
                    queueOffset.setOffset(pullResult.getNextQueueOffset().getOffset());
                    queueOffset.setOffset(pullResult.getNextQueueOffset().getOffset());
                    session.markPersistOffsetFlag(true);
                    this.pullMessage(session, subscription, queue);
                } else {
                    logger.error("response:{},{}", (Object)session.getClientId(), (Object)JSONObject.toJSONString((Object)pullResult));
                }
            }
            finally {
                this.clearPullStatus(session, queue, pullEvent);
            }
        });
        PullResultStatus pullResultStatus = this.queueCache.pullMessage(session, subscription, queue, queueOffset, count, result);
        if (PullResultStatus.LATER.equals((Object)pullResultStatus)) {
            this.clearPullStatus(session, queue, pullEvent);
            this.scheduler.schedule(() -> this.pullMessage(session, subscription, queue), this.pullIntervalMillis, TimeUnit.MILLISECONDS);
        }
    }

    private void clearPullStatus(Session session, Queue queue, PullEvent pullEvent) {
        this.pullEventMap.remove(this.eventQueueKey(session, queue), pullEvent);
        this.pullStatus.remove(this.eventQueueKey(session, queue));
    }

    private void persistAllOffset(boolean needSleep) {
        try {
            for (Session session : this.sessionMap.values()) {
                if (session.isClean() || !this.persistOffset(session) || !needSleep) continue;
                Thread.sleep(5L);
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }

    private boolean persistOffset(Session session) {
        try {
            if (session.isClean()) {
                return true;
            }
            if (!session.getPersistOffsetFlag()) {
                return false;
            }
            this.lmqOffsetStore.save(session.getClientId(), session.offsetMapSnapshot());
        }
        catch (Exception e) {
            logger.error("{}", (Object)session.getClientId(), (Object)e);
        }
        return true;
    }

    class PullEvent {
        private Session session;
        private Subscription subscription;
        private Queue queue;
        private long id;

        public PullEvent(Session session, Subscription subscription, Queue queue) {
            this.id = SessionLoopImpl.this.rid.getAndIncrement();
            this.session = session;
            this.subscription = subscription;
            this.queue = queue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PullEvent pullEvent = (PullEvent)o;
            return this.id == pullEvent.id;
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }
}

