/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.meta.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.mqtt.meta.config.MetaConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MetaConfListener {
    private static Logger logger = LoggerFactory.getLogger(MetaConfListener.class);
    @Resource
    private MetaConf metaConf;
    private File confFile;
    private ScheduledThreadPoolExecutor scheduler;
    private AtomicLong gmt = new AtomicLong();
    private long refreshSecs = 3L;

    @PostConstruct
    public void start() {
        this.confFile = this.metaConf.getConfFile();
        this.gmt.set(this.confFile.lastModified());
        this.scheduler = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new ThreadFactoryImpl("ConnectConfListener"));
        this.scheduler.scheduleWithFixedDelay(() -> {
            try {
                if (this.gmt.get() == this.confFile.lastModified()) {
                    return;
                }
                this.gmt.set(this.confFile.lastModified());
                FileInputStream in = new FileInputStream(this.confFile.getAbsoluteFile());
                Properties properties = new Properties();
                properties.load(in);
                ((InputStream)in).close();
                MixAll.properties2Object((Properties)properties, (Object)this.metaConf);
                logger.warn("UpdateConf:{}", (Object)this.confFile.getAbsolutePath());
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
        }, this.refreshSecs, this.refreshSecs, TimeUnit.SECONDS);
    }
}

