/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.command.message;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.rocketmq.client.QueryResult;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.protocol.body.ConsumeMessageDirectlyResult;
import org.apache.rocketmq.remoting.protocol.body.ConsumerRunningInfo;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.apache.rocketmq.tools.admin.api.MessageTrack;
import org.apache.rocketmq.tools.command.SubCommand;
import org.apache.rocketmq.tools.command.SubCommandException;

public class QueryMsgByUniqueKeySubCommand
implements SubCommand {
    private DefaultMQAdminExt defaultMQAdminExt;

    private DefaultMQAdminExt createMQAdminExt(RPCHook rpcHook) throws SubCommandException {
        if (this.defaultMQAdminExt != null) {
            return this.defaultMQAdminExt;
        }
        this.defaultMQAdminExt = new DefaultMQAdminExt(rpcHook);
        this.defaultMQAdminExt.setInstanceName(Long.toString(System.currentTimeMillis()));
        try {
            this.defaultMQAdminExt.start();
        }
        catch (Exception e) {
            throw new SubCommandException(this.getClass().getSimpleName() + " command failed", e);
        }
        return this.defaultMQAdminExt;
    }

    public static void queryById(DefaultMQAdminExt admin, String clusterName, String topic, String msgId, boolean showAll) throws MQClientException, InterruptedException, IOException {
        QueryResult queryResult = admin.queryMessageByUniqKey(clusterName, topic, msgId, 32, 0L, Long.MAX_VALUE);
        assert (queryResult != null);
        List list = queryResult.getMessageList();
        if (list == null || list.size() == 0) {
            return;
        }
        list.sort((o1, o2) -> (int)(o1.getStoreTimestamp() - o2.getStoreTimestamp()));
        for (int i = 0; i < (showAll ? list.size() : 1); ++i) {
            QueryMsgByUniqueKeySubCommand.showMessage(admin, (MessageExt)list.get(i), i);
        }
    }

    private static void showMessage(DefaultMQAdminExt admin, MessageExt msg, int index) throws IOException {
        String bodyTmpFilePath = QueryMsgByUniqueKeySubCommand.createBodyFile(msg, index);
        String strFormat = "%-20s %s%n";
        String intFormat = "%-20s %d%n";
        System.out.printf("%-20s %s%n", "Topic:", msg.getTopic());
        System.out.printf("%-20s %s%n", "Tags:", "[" + msg.getTags() + "]");
        System.out.printf("%-20s %s%n", "Keys:", "[" + msg.getKeys() + "]");
        System.out.printf("%-20s %d%n", "Queue ID:", msg.getQueueId());
        System.out.printf("%-20s %d%n", "Queue Offset:", msg.getQueueOffset());
        System.out.printf("%-20s %d%n", "CommitLog Offset:", msg.getCommitLogOffset());
        System.out.printf("%-20s %d%n", "Reconsume Times:", msg.getReconsumeTimes());
        System.out.printf("%-20s %s%n", "Born Timestamp:", UtilAll.timeMillisToHumanString2((long)msg.getBornTimestamp()));
        System.out.printf("%-20s %s%n", "Store Timestamp:", UtilAll.timeMillisToHumanString2((long)msg.getStoreTimestamp()));
        System.out.printf("%-20s %s%n", "Born Host:", RemotingHelper.parseSocketAddressAddr((SocketAddress)msg.getBornHost()));
        System.out.printf("%-20s %s%n", "Store Host:", RemotingHelper.parseSocketAddressAddr((SocketAddress)msg.getStoreHost()));
        System.out.printf("%-20s %d%n", "System Flag:", msg.getSysFlag());
        System.out.printf("%-20s %s%n", "Properties:", msg.getProperties() != null ? msg.getProperties().toString() : "");
        System.out.printf("%-20s %s%n", "Message Body Path:", bodyTmpFilePath);
        try {
            List<MessageTrack> mtdList = admin.messageTrackDetail(msg);
            if (mtdList.isEmpty()) {
                System.out.printf("%n%nWARN: No Consumer", new Object[0]);
            } else {
                System.out.printf("%n%n", new Object[0]);
                for (MessageTrack mt : mtdList) {
                    System.out.printf("%s", mt);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String createBodyFile(MessageExt msg, int index) throws IOException {
        try (FilterOutputStream dos = null;){
            StringBuilder bodyTmpFilePath = new StringBuilder("/tmp/rocketmq/msgbodys");
            File file = new File(bodyTmpFilePath.toString());
            if (!file.exists()) {
                file.mkdirs();
            }
            bodyTmpFilePath.append("/").append(msg.getMsgId());
            if (index > 0) {
                bodyTmpFilePath.append("_" + index);
            }
            dos = new DataOutputStream(new FileOutputStream(bodyTmpFilePath.toString()));
            dos.write(msg.getBody());
            String string = bodyTmpFilePath.toString();
            return string;
        }
    }

    @Override
    public String commandName() {
        return "queryMsgByUniqueKey";
    }

    @Override
    public String commandDesc() {
        return "Query Message by Unique key.";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        Option opt = new Option("i", "msgId", true, "Message Id");
        opt.setRequired(true);
        options.addOption(opt);
        opt = new Option("g", "consumerGroup", true, "consumer group name");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("d", "clientId", true, "The consumer's client id");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("t", "topic", true, "The topic of msg");
        opt.setRequired(true);
        options.addOption(opt);
        opt = new Option("a", "showAll", false, "Print all message, the limit is 32");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("c", "cluster", true, "Cluster name or lmq parent topic, lmq is used to find the route.");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }

    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) throws SubCommandException {
        block10: {
            try {
                this.defaultMQAdminExt = this.createMQAdminExt(rpcHook);
                String msgId = commandLine.getOptionValue('i').trim();
                String topic = commandLine.getOptionValue('t').trim();
                String clusterName = commandLine.hasOption('c') ? commandLine.getOptionValue('c').trim() : null;
                boolean showAll = commandLine.hasOption('a');
                if (commandLine.hasOption('g') && commandLine.hasOption('d')) {
                    String consumerGroup = commandLine.getOptionValue('g').trim();
                    String clientId = commandLine.getOptionValue('d').trim();
                    ConsumerRunningInfo consumerRunningInfo = null;
                    try {
                        consumerRunningInfo = this.defaultMQAdminExt.getConsumerRunningInfo(consumerGroup, clientId, false, false);
                    }
                    catch (Exception e) {
                        System.out.printf("get consumer runtime info for %s client failed \n", clientId);
                    }
                    if (consumerRunningInfo != null && ConsumerRunningInfo.isPushType((ConsumerRunningInfo)consumerRunningInfo)) {
                        ConsumeMessageDirectlyResult result = this.defaultMQAdminExt.consumeMessageDirectly(consumerGroup, clientId, topic, msgId);
                        System.out.printf("%s", result);
                    } else {
                        System.out.printf("get consumer info failed or this %s client is not push consumer, not support direct push \n", clientId);
                    }
                    break block10;
                }
                QueryMsgByUniqueKeySubCommand.queryById(this.defaultMQAdminExt, clusterName, topic, msgId, showAll);
            }
            catch (Exception e) {
                throw new SubCommandException(this.getClass().getSimpleName() + " command failed", e);
            }
            finally {
                this.defaultMQAdminExt.shutdown();
            }
        }
    }
}

