/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting.rpc.protocol;

import com.alipay.remoting.CustomSerializer;
import com.alipay.remoting.CustomSerializerManager;
import com.alipay.remoting.InvokeContext;
import com.alipay.remoting.exception.DeserializationException;
import com.alipay.remoting.exception.SerializationException;
import com.alipay.remoting.rpc.RequestCommand;
import com.alipay.remoting.rpc.protocol.RpcCommandCode;
import com.alipay.remoting.serialization.SerializerManager;
import com.alipay.remoting.util.IDGenerator;
import java.io.UnsupportedEncodingException;

public class RpcRequestCommand
extends RequestCommand {
    private static final long serialVersionUID = -4602613826188210946L;
    private Object requestObject;
    private String requestClass;
    private CustomSerializer customSerializer;
    private Object requestHeader;
    private transient long arriveTime = -1L;
    private transient long arriveHeaderTimeInNano = -1L;
    private transient long arriveBodyTimeInNano = -1L;
    private transient long beforeEnterQueueTime = -1L;

    public RpcRequestCommand() {
        super(RpcCommandCode.RPC_REQUEST);
    }

    public RpcRequestCommand(Object request) {
        super(RpcCommandCode.RPC_REQUEST);
        this.requestObject = request;
        this.setId(IDGenerator.nextId());
    }

    @Override
    public void serializeClazz() throws SerializationException {
        if (this.requestClass != null) {
            try {
                byte[] clz = this.requestClass.getBytes("UTF-8");
                this.setClazz(clz);
            }
            catch (UnsupportedEncodingException e) {
                throw new SerializationException("Unsupported charset: UTF-8", e);
            }
        }
    }

    @Override
    public void deserializeClazz() throws DeserializationException {
        if (this.getClazz() != null && this.getRequestClass() == null) {
            try {
                this.setRequestClass(new String(this.getClazz(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new DeserializationException("Unsupported charset: UTF-8", e);
            }
        }
    }

    @Override
    public void serializeHeader(InvokeContext invokeContext) throws SerializationException {
        if (this.getCustomSerializer() != null) {
            try {
                this.getCustomSerializer().serializeHeader(this, invokeContext);
            }
            catch (SerializationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SerializationException("Exception caught when serialize header of rpc request command!", e);
            }
        }
    }

    @Override
    public void deserializeHeader(InvokeContext invokeContext) throws DeserializationException {
        if (this.getHeader() != null && this.getRequestHeader() == null && this.getCustomSerializer() != null) {
            try {
                this.getCustomSerializer().deserializeHeader(this);
            }
            catch (DeserializationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DeserializationException("Exception caught when deserialize header of rpc request command!", e);
            }
        }
    }

    @Override
    public void serializeContent(InvokeContext invokeContext) throws SerializationException {
        if (this.requestObject != null) {
            try {
                if (this.getCustomSerializer() != null && this.getCustomSerializer().serializeContent(this, invokeContext)) {
                    return;
                }
                this.setContent(SerializerManager.getSerializer(this.getSerializer()).serialize(this.requestObject));
            }
            catch (SerializationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SerializationException("Exception caught when serialize content of rpc request command!", e);
            }
        }
    }

    @Override
    public void deserializeContent(InvokeContext invokeContext) throws DeserializationException {
        if (this.getRequestObject() == null) {
            try {
                if (this.getCustomSerializer() != null && this.getCustomSerializer().deserializeContent(this)) {
                    return;
                }
                if (this.getContent() != null) {
                    this.setRequestObject(SerializerManager.getSerializer(this.getSerializer()).deserialize(this.getContent(), this.requestClass));
                }
            }
            catch (DeserializationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DeserializationException("Exception caught when deserialize content of rpc request command!", e);
            }
        }
    }

    public Object getRequestObject() {
        return this.requestObject;
    }

    public void setRequestObject(Object requestObject) {
        this.requestObject = requestObject;
    }

    public Object getRequestHeader() {
        return this.requestHeader;
    }

    public void setRequestHeader(Object requestHeader) {
        this.requestHeader = requestHeader;
    }

    public String getRequestClass() {
        return this.requestClass;
    }

    public void setRequestClass(String requestClass) {
        this.requestClass = requestClass;
    }

    public CustomSerializer getCustomSerializer() {
        if (this.customSerializer != null) {
            return this.customSerializer;
        }
        if (this.requestClass != null) {
            this.customSerializer = CustomSerializerManager.getCustomSerializer(this.requestClass);
        }
        if (this.customSerializer == null) {
            this.customSerializer = CustomSerializerManager.getCustomSerializer(this.getCmdCode());
        }
        return this.customSerializer;
    }

    public long getArriveTime() {
        return this.arriveTime;
    }

    public void setArriveTime(long arriveTime) {
        this.arriveTime = arriveTime;
    }

    public long getArriveHeaderTimeInNano() {
        return this.arriveHeaderTimeInNano;
    }

    public void setArriveHeaderTimeInNano(long arriveHeaderTimeInNano) {
        this.arriveHeaderTimeInNano = arriveHeaderTimeInNano;
    }

    public long getArriveBodyTimeInNano() {
        return this.arriveBodyTimeInNano;
    }

    public void setArriveBodyTimeInNano(long arriveBodyTimeInNano) {
        this.arriveBodyTimeInNano = arriveBodyTimeInNano;
    }

    public long getBeforeEnterQueueTime() {
        return this.beforeEnterQueueTime;
    }

    public void setBeforeEnterQueueTime(long beforeEnterQueueTime) {
        this.beforeEnterQueueTime = beforeEnterQueueTime;
    }
}

