/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.config;

import com.google.common.base.Strings;
import java.io.File;
import org.apache.rocketmq.common.UtilAll;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.Cache;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.CompactionStyle;
import org.rocksdb.CompressionType;
import org.rocksdb.DBOptions;
import org.rocksdb.DataBlockIndexType;
import org.rocksdb.Filter;
import org.rocksdb.IndexType;
import org.rocksdb.InfoLogLevel;
import org.rocksdb.LRUCache;
import org.rocksdb.MemTableConfig;
import org.rocksdb.MergeOperator;
import org.rocksdb.RateLimiter;
import org.rocksdb.SkipListMemTableConfig;
import org.rocksdb.Statistics;
import org.rocksdb.StatsLevel;
import org.rocksdb.StringAppendOperator;
import org.rocksdb.TableFormatConfig;
import org.rocksdb.WALRecoveryMode;

public class ConfigHelper {
    public static ColumnFamilyOptions createConfigColumnFamilyOptions() {
        BlockBasedTableConfig blockBasedTableConfig = new BlockBasedTableConfig().setFormatVersion(5).setIndexType(IndexType.kBinarySearch).setDataBlockIndexType(DataBlockIndexType.kDataBlockBinarySearch).setBlockSize(32768L).setFilterPolicy((Filter)new BloomFilter(16.0, false)).setCacheIndexAndFilterBlocks(true).setCacheIndexAndFilterBlocksWithHighPriority(true).setPinL0FilterAndIndexBlocksInCache(false).setPinTopLevelIndexAndFilter(true).setBlockCache((Cache)new LRUCache(0x400000L, 8, false)).setWholeKeyFiltering(true);
        ColumnFamilyOptions options = new ColumnFamilyOptions();
        return options.setMaxWriteBufferNumber(4).setWriteBufferSize(0x4000000L).setMinWriteBufferNumberToMerge(1).setTableFormatConfig((TableFormatConfig)blockBasedTableConfig).setMemTableConfig((MemTableConfig)new SkipListMemTableConfig()).setCompressionType(CompressionType.NO_COMPRESSION).setNumLevels(7).setCompactionStyle(CompactionStyle.LEVEL).setLevel0FileNumCompactionTrigger(4).setLevel0SlowdownWritesTrigger(8).setLevel0StopWritesTrigger(12).setTargetFileSizeBase(0x4000000L).setTargetFileSizeMultiplier(2).setMaxBytesForLevelBase(0x10000000L).setMaxBytesForLevelMultiplier(2.0).setMergeOperator((MergeOperator)new StringAppendOperator()).setInplaceUpdateSupport(true);
    }

    public static DBOptions createConfigDBOptions() {
        DBOptions options = new DBOptions();
        Statistics statistics = new Statistics();
        statistics.setStatsLevel(StatsLevel.EXCEPT_DETAILED_TIMERS);
        return options.setDbLogDir(ConfigHelper.getDBLogDir()).setInfoLogLevel(InfoLogLevel.INFO_LEVEL).setWalRecoveryMode(WALRecoveryMode.SkipAnyCorruptedRecords).setManualWalFlush(true).setDbWriteBufferSize(0x8000000L).setBytesPerSync(0x100000L).setWalBytesPerSync(0x100000L).setCreateIfMissing(true).setCreateMissingColumnFamilies(true).setMaxOpenFiles(-1).setMaxLogFileSize(0x40000000L).setKeepLogFileNum(5L).setMaxManifestFileSize(0x40000000L).setAllowConcurrentMemtableWrite(false).setStatistics(statistics).setStatsDumpPeriodSec(600).setMaxBackgroundJobs(32).setMaxSubcompactions(4).setParanoidChecks(true).setDelayedWriteRate(0x1000000L).setRateLimiter(new RateLimiter(0x6400000L)).setUseDirectIoForFlushAndCompaction(true).setUseDirectReads(true);
    }

    public static String getDBLogDir() {
        String[] rootPaths;
        for (String rootPath : rootPaths = new String[]{System.getProperty("user.home"), System.getProperty("java.io.tmpdir"), File.separator + "data"}) {
            File rootPathFile;
            if (Strings.isNullOrEmpty((String)rootPath) || !(rootPathFile = new File(rootPath)).exists() || !rootPathFile.canWrite()) continue;
            String logDirectory = rootPath + File.separator + "logs" + File.separator + "rocketmqlogs";
            UtilAll.ensureDirOK(logDirectory);
            return logDirectory;
        }
        throw new RuntimeException("Failed to get log directory");
    }
}

