/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.metrics;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongGauge;
import io.opentelemetry.sdk.metrics.InstrumentSelector;
import io.opentelemetry.sdk.metrics.View;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.rocketmq.common.Pair;
import org.apache.rocketmq.common.metrics.NopLongCounter;
import org.apache.rocketmq.common.metrics.NopObservableLongGauge;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.config.MessageStoreConfig;
import org.apache.rocketmq.store.timer.TimerMessageStore;

public class DefaultStoreMetricsManager {
    public static Supplier<AttributesBuilder> attributesBuilderSupplier;
    public static MessageStoreConfig messageStoreConfig;
    public static ObservableLongGauge storageSize;
    public static ObservableLongGauge flushBehind;
    public static ObservableLongGauge dispatchBehind;
    public static ObservableLongGauge messageReserveTime;
    public static ObservableLongGauge timerEnqueueLag;
    public static ObservableLongGauge timerEnqueueLatency;
    public static ObservableLongGauge timerDequeueLag;
    public static ObservableLongGauge timerDequeueLatency;
    public static ObservableLongGauge timingMessages;
    public static LongCounter timerDequeueTotal;
    public static LongCounter timerEnqueueTotal;

    public static List<Pair<InstrumentSelector, View>> getMetricsView() {
        return Collections.emptyList();
    }

    public static void init(Meter meter, Supplier<AttributesBuilder> attributesBuilderSupplier, DefaultMessageStore messageStore) {
        DefaultStoreMetricsManager.attributesBuilderSupplier = attributesBuilderSupplier;
        messageStoreConfig = messageStore.getMessageStoreConfig();
        storageSize = meter.gaugeBuilder("rocketmq_storage_size").setDescription("Broker storage size").setUnit("bytes").ofLongs().buildWithCallback(measurement -> {
            long totalSpace;
            File storeDir = new File(messageStoreConfig.getStorePathRootDir());
            if (storeDir.exists() && storeDir.isDirectory() && (totalSpace = storeDir.getTotalSpace()) > 0L) {
                measurement.record(totalSpace - storeDir.getFreeSpace(), DefaultStoreMetricsManager.newAttributesBuilder().build());
            }
        });
        flushBehind = meter.gaugeBuilder("rocketmq_storage_flush_behind_bytes").setDescription("Broker flush behind bytes").setUnit("bytes").ofLongs().buildWithCallback(measurement -> measurement.record(messageStore.flushBehindBytes(), DefaultStoreMetricsManager.newAttributesBuilder().build()));
        dispatchBehind = meter.gaugeBuilder("rocketmq_storage_dispatch_behind_bytes").setDescription("Broker dispatch behind bytes").setUnit("bytes").ofLongs().buildWithCallback(measurement -> measurement.record(messageStore.dispatchBehindBytes(), DefaultStoreMetricsManager.newAttributesBuilder().build()));
        messageReserveTime = meter.gaugeBuilder("rocketmq_storage_message_reserve_time").setDescription("Broker message reserve time").setUnit("milliseconds").ofLongs().buildWithCallback(measurement -> {
            long earliestMessageTime = messageStore.getEarliestMessageTime();
            if (earliestMessageTime <= 0L) {
                return;
            }
            measurement.record(System.currentTimeMillis() - earliestMessageTime, DefaultStoreMetricsManager.newAttributesBuilder().build());
        });
        timerEnqueueLag = meter.gaugeBuilder("rocketmq_timer_enqueue_lag").setDescription("Timer enqueue messages lag").ofLongs().buildWithCallback(measurement -> {
            TimerMessageStore timerMessageStore = messageStore.getTimerMessageStore();
            measurement.record(timerMessageStore.getEnqueueBehindMessages(), DefaultStoreMetricsManager.newAttributesBuilder().build());
        });
        timerEnqueueLatency = meter.gaugeBuilder("rocketmq_timer_enqueue_latency").setDescription("Timer enqueue latency").setUnit("milliseconds").ofLongs().buildWithCallback(measurement -> {
            TimerMessageStore timerMessageStore = messageStore.getTimerMessageStore();
            measurement.record(timerMessageStore.getEnqueueBehindMillis(), DefaultStoreMetricsManager.newAttributesBuilder().build());
        });
        timerDequeueLag = meter.gaugeBuilder("rocketmq_timer_dequeue_lag").setDescription("Timer dequeue messages lag").ofLongs().buildWithCallback(measurement -> {
            TimerMessageStore timerMessageStore = messageStore.getTimerMessageStore();
            measurement.record(timerMessageStore.getDequeueBehindMessages(), DefaultStoreMetricsManager.newAttributesBuilder().build());
        });
        timerDequeueLatency = meter.gaugeBuilder("rocketmq_timer_dequeue_latency").setDescription("Timer dequeue latency").setUnit("milliseconds").ofLongs().buildWithCallback(measurement -> {
            TimerMessageStore timerMessageStore = messageStore.getTimerMessageStore();
            measurement.record(timerMessageStore.getDequeueBehind(), DefaultStoreMetricsManager.newAttributesBuilder().build());
        });
        timingMessages = meter.gaugeBuilder("rocketmq_timing_messages").setDescription("Current message number in timing").ofLongs().buildWithCallback(measurement -> {
            TimerMessageStore timerMessageStore = messageStore.getTimerMessageStore();
            timerMessageStore.getTimerMetrics().getTimingCount().forEach((topic, metric) -> measurement.record(metric.getCount().get(), DefaultStoreMetricsManager.newAttributesBuilder().put("topic", topic).build()));
        });
        timerDequeueTotal = meter.counterBuilder("rocketmq_timer_dequeue_total").setDescription("Total number of timer dequeue").build();
        timerEnqueueTotal = meter.counterBuilder("rocketmq_timer_enqueue_total").setDescription("Total number of timer enqueue").build();
    }

    public static void incTimerDequeueCount(String topic) {
        timerDequeueTotal.add(1L, DefaultStoreMetricsManager.newAttributesBuilder().put("topic", topic).build());
    }

    public static void incTimerEnqueueCount(String topic) {
        AttributesBuilder attributesBuilder = DefaultStoreMetricsManager.newAttributesBuilder();
        if (topic != null) {
            attributesBuilder.put("topic", topic);
        }
        timerEnqueueTotal.add(1L, attributesBuilder.build());
    }

    public static AttributesBuilder newAttributesBuilder() {
        if (attributesBuilderSupplier == null) {
            return Attributes.builder();
        }
        return attributesBuilderSupplier.get().put("storage_type", "local").put("storage_medium", "disk");
    }

    static {
        storageSize = new NopObservableLongGauge();
        flushBehind = new NopObservableLongGauge();
        dispatchBehind = new NopObservableLongGauge();
        messageReserveTime = new NopObservableLongGauge();
        timerEnqueueLag = new NopObservableLongGauge();
        timerEnqueueLatency = new NopObservableLongGauge();
        timerDequeueLag = new NopObservableLongGauge();
        timerDequeueLatency = new NopObservableLongGauge();
        timingMessages = new NopObservableLongGauge();
        timerDequeueTotal = new NopLongCounter();
        timerEnqueueTotal = new NopLongCounter();
    }
}

