/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.ha;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.CommitLog;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.PutMessageSpinLock;
import org.apache.rocketmq.store.PutMessageStatus;
import org.apache.rocketmq.store.ha.HAConnection;
import org.apache.rocketmq.store.ha.HAService;
import org.apache.rocketmq.store.ha.WaitNotifyObject;
import org.apache.rocketmq.store.ha.autoswitch.AutoSwitchHAConnection;
import org.apache.rocketmq.store.ha.autoswitch.AutoSwitchHAService;

public class GroupTransferService
extends ServiceThread {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    private final WaitNotifyObject notifyTransferObject = new WaitNotifyObject();
    private final PutMessageSpinLock lock = new PutMessageSpinLock();
    private volatile List<CommitLog.GroupCommitRequest> requestsWrite = new LinkedList<CommitLog.GroupCommitRequest>();
    private volatile List<CommitLog.GroupCommitRequest> requestsRead = new LinkedList<CommitLog.GroupCommitRequest>();
    private HAService haService;
    private DefaultMessageStore defaultMessageStore;

    public GroupTransferService(HAService haService, DefaultMessageStore defaultMessageStore) {
        this.haService = haService;
        this.defaultMessageStore = defaultMessageStore;
    }

    public void putRequest(CommitLog.GroupCommitRequest request) {
        this.lock.lock();
        try {
            this.requestsWrite.add(request);
        }
        finally {
            this.lock.unlock();
        }
        this.wakeup();
    }

    public void notifyTransferSome() {
        this.notifyTransferObject.wakeup();
    }

    private void swapRequests() {
        this.lock.lock();
        try {
            List<CommitLog.GroupCommitRequest> tmp = this.requestsWrite;
            this.requestsWrite = this.requestsRead;
            this.requestsRead = tmp;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void doWaitTransfer() {
        if (!this.requestsRead.isEmpty()) {
            for (CommitLog.GroupCommitRequest req : this.requestsRead) {
                boolean transferOK = false;
                long deadLine = req.getDeadLine();
                boolean allAckInSyncStateSet = req.getAckNums() == -1;
                int i = 0;
                while (!transferOK && deadLine - System.nanoTime() > 0L) {
                    if (i > 0) {
                        this.notifyTransferObject.waitForRunning(1000L);
                    }
                    if (!allAckInSyncStateSet && req.getAckNums() <= 1) {
                        transferOK = this.haService.getPush2SlaveMaxOffset().get() >= req.getNextOffset();
                    } else if (allAckInSyncStateSet && this.haService instanceof AutoSwitchHAService) {
                        AutoSwitchHAService autoSwitchHAService = (AutoSwitchHAService)this.haService;
                        Set<String> syncStateSet = autoSwitchHAService.getSyncStateSet();
                        if (syncStateSet.size() <= 1) {
                            transferOK = true;
                            break;
                        }
                        int ackNums = 1;
                        for (HAConnection conn : this.haService.getConnectionList()) {
                            AutoSwitchHAConnection autoSwitchHAConnection = (AutoSwitchHAConnection)conn;
                            if (syncStateSet.contains(autoSwitchHAConnection.getSlaveAddress()) && autoSwitchHAConnection.getSlaveAckOffset() >= req.getNextOffset()) {
                                ++ackNums;
                            }
                            if (ackNums < syncStateSet.size()) continue;
                            transferOK = true;
                            break;
                        }
                    } else {
                        int ackNums = 1;
                        for (HAConnection conn : this.haService.getConnectionList()) {
                            if (conn.getSlaveAckOffset() >= req.getNextOffset()) {
                                ++ackNums;
                            }
                            if (ackNums < req.getAckNums()) continue;
                            transferOK = true;
                            break;
                        }
                    }
                    ++i;
                }
                if (!transferOK) {
                    log.warn("transfer message to slave timeout, offset : {}, request acks: {}", (Object)req.getNextOffset(), (Object)req.getAckNums());
                }
                req.wakeupCustomer(transferOK ? PutMessageStatus.PUT_OK : PutMessageStatus.FLUSH_SLAVE_TIMEOUT);
            }
            this.requestsRead = new LinkedList<CommitLog.GroupCommitRequest>();
        }
    }

    public void run() {
        log.info(this.getServiceName() + " service started");
        while (!this.isStopped()) {
            try {
                this.waitForRunning(10L);
                this.doWaitTransfer();
            }
            catch (Exception e) {
                log.warn(this.getServiceName() + " service has exception. ", (Throwable)e);
            }
        }
        log.info(this.getServiceName() + " service end");
    }

    protected void onWaitEnd() {
        this.swapRequests();
    }

    public String getServiceName() {
        if (this.defaultMessageStore != null && this.defaultMessageStore.getBrokerConfig().isInBrokerContainer()) {
            return this.defaultMessageStore.getBrokerIdentity().getIdentifier() + GroupTransferService.class.getSimpleName();
        }
        return GroupTransferService.class.getSimpleName();
    }
}

