/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class StructureDefinition extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 101;
  }

  // Properties.
  protected final NodeId defaultEncodingId;
  protected final NodeId baseDataType;
  protected final StructureType structureType;
  protected final List<StructureField> fields;

  public StructureDefinition(
      NodeId defaultEncodingId,
      NodeId baseDataType,
      StructureType structureType,
      List<StructureField> fields) {
    super();
    this.defaultEncodingId = defaultEncodingId;
    this.baseDataType = baseDataType;
    this.structureType = structureType;
    this.fields = fields;
  }

  public NodeId getDefaultEncodingId() {
    return defaultEncodingId;
  }

  public NodeId getBaseDataType() {
    return baseDataType;
  }

  public StructureType getStructureType() {
    return structureType;
  }

  public List<StructureField> getFields() {
    return fields;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("StructureDefinition");

    // Simple Field (defaultEncodingId)
    writeSimpleField("defaultEncodingId", defaultEncodingId, writeComplex(writeBuffer));

    // Simple Field (baseDataType)
    writeSimpleField("baseDataType", baseDataType, writeComplex(writeBuffer));

    // Simple Field (structureType)
    writeSimpleEnumField(
        "structureType",
        "StructureType",
        structureType,
        writeEnum(
            StructureType::getValue, StructureType::name, writeUnsignedLong(writeBuffer, 32)));

    // Implicit Field (noOfFields) (Used for parsing, but its value is not stored as it's implicitly
    // given by the objects content)
    int noOfFields = (int) ((((getFields()) == (null)) ? -(1) : COUNT(getFields())));
    writeImplicitField("noOfFields", noOfFields, writeSignedInt(writeBuffer, 32));

    // Array Field (fields)
    writeComplexTypeArrayField("fields", fields, writeBuffer);

    writeBuffer.popContext("StructureDefinition");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    StructureDefinition _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (defaultEncodingId)
    lengthInBits += defaultEncodingId.getLengthInBits();

    // Simple field (baseDataType)
    lengthInBits += baseDataType.getLengthInBits();

    // Simple field (structureType)
    lengthInBits += 32;

    // Implicit Field (noOfFields)
    lengthInBits += 32;

    // Array field
    if (fields != null) {
      int i = 0;
      for (StructureField element : fields) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= fields.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("StructureDefinition");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    NodeId defaultEncodingId =
        readSimpleField(
            "defaultEncodingId", readComplex(() -> NodeId.staticParse(readBuffer), readBuffer));

    NodeId baseDataType =
        readSimpleField(
            "baseDataType", readComplex(() -> NodeId.staticParse(readBuffer), readBuffer));

    StructureType structureType =
        readEnumField(
            "structureType",
            "StructureType",
            readEnum(StructureType::enumForValue, readUnsignedLong(readBuffer, 32)));

    int noOfFields = readImplicitField("noOfFields", readSignedInt(readBuffer, 32));

    List<StructureField> fields =
        readCountArrayField(
            "fields",
            readComplex(
                () ->
                    (StructureField) ExtensionObjectDefinition.staticParse(readBuffer, (int) (103)),
                readBuffer),
            noOfFields);

    readBuffer.closeContext("StructureDefinition");
    // Create the instance
    return new StructureDefinitionBuilderImpl(
        defaultEncodingId, baseDataType, structureType, fields);
  }

  public static class StructureDefinitionBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final NodeId defaultEncodingId;
    private final NodeId baseDataType;
    private final StructureType structureType;
    private final List<StructureField> fields;

    public StructureDefinitionBuilderImpl(
        NodeId defaultEncodingId,
        NodeId baseDataType,
        StructureType structureType,
        List<StructureField> fields) {
      this.defaultEncodingId = defaultEncodingId;
      this.baseDataType = baseDataType;
      this.structureType = structureType;
      this.fields = fields;
    }

    public StructureDefinition build() {
      StructureDefinition structureDefinition =
          new StructureDefinition(defaultEncodingId, baseDataType, structureType, fields);
      return structureDefinition;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof StructureDefinition)) {
      return false;
    }
    StructureDefinition that = (StructureDefinition) o;
    return (getDefaultEncodingId() == that.getDefaultEncodingId())
        && (getBaseDataType() == that.getBaseDataType())
        && (getStructureType() == that.getStructureType())
        && (getFields() == that.getFields())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getDefaultEncodingId(),
        getBaseDataType(),
        getStructureType(),
        getFields());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
