/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*
 * ctrlX CORE - Data Layer API
 * This is the base API for the ctrlX Data Layer access on ctrlX CORE devices <ul> <li>Click 'Authorize' to open the 'Available authorizations' dialog.</li> <li>Enter 'username' and 'password'. The 'Client credentials location' selector together with the 'client_id' and 'client_secret' fields as well as the 'Bearer' section can be ignored.</li> <li>Click 'Authorize' and then 'Close' to close the 'Available authorizations' dialog.</li> <li>Try out those GET, PUT, ... operations you're interested in.</li> </ul>
 *
 * The version of the OpenAPI document: 2.1.0
 * Contact: support@boschrexroth.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.plc4x.java.ctrlx.readwrite.rest.datalayer.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;
import java.util.StringJoiner;

/**
 * Global Subscription Settings. Subscriptions
 */
@JsonPropertyOrder({
  SubscriptionSettings.JSON_PROPERTY_MINIMUM_PUBLISH_INTERVAL,
  SubscriptionSettings.JSON_PROPERTY_MINIMUM_SAMPLE_INTERVAL,
  SubscriptionSettings.JSON_PROPERTY_MAXIMUM_BUFFER_SIZE,
  SubscriptionSettings.JSON_PROPERTY_MINIMUM_ERROR_INTERVAL
})
@JsonTypeName("SubscriptionSettings")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-18T13:34:36.056861+01:00[Europe/Berlin]")
public class SubscriptionSettings {
  public static final String JSON_PROPERTY_MINIMUM_PUBLISH_INTERVAL = "minimumPublishInterval";
  private Integer minimumPublishInterval;

  public static final String JSON_PROPERTY_MINIMUM_SAMPLE_INTERVAL = "minimumSampleInterval";
  private Integer minimumSampleInterval;

  public static final String JSON_PROPERTY_MAXIMUM_BUFFER_SIZE = "maximumBufferSize";
  private Integer maximumBufferSize;

  public static final String JSON_PROPERTY_MINIMUM_ERROR_INTERVAL = "minimumErrorInterval";
  private Integer minimumErrorInterval;

  public SubscriptionSettings() {
  }

  public SubscriptionSettings minimumPublishInterval(Integer minimumPublishInterval) {
    
    this.minimumPublishInterval = minimumPublishInterval;
    return this;
  }

   /**
   * minimum publish interval in milliseconds
   * minimum: 0
   * maximum: 4294967295
   * @return minimumPublishInterval
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MINIMUM_PUBLISH_INTERVAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMinimumPublishInterval() {
    return minimumPublishInterval;
  }


  @JsonProperty(JSON_PROPERTY_MINIMUM_PUBLISH_INTERVAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinimumPublishInterval(Integer minimumPublishInterval) {
    this.minimumPublishInterval = minimumPublishInterval;
  }


  public SubscriptionSettings minimumSampleInterval(Integer minimumSampleInterval) {
    
    this.minimumSampleInterval = minimumSampleInterval;
    return this;
  }

   /**
   * minimum sampling interval in microseconds
   * minimum: 0
   * maximum: 4294967295
   * @return minimumSampleInterval
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MINIMUM_SAMPLE_INTERVAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMinimumSampleInterval() {
    return minimumSampleInterval;
  }


  @JsonProperty(JSON_PROPERTY_MINIMUM_SAMPLE_INTERVAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinimumSampleInterval(Integer minimumSampleInterval) {
    this.minimumSampleInterval = minimumSampleInterval;
  }


  public SubscriptionSettings maximumBufferSize(Integer maximumBufferSize) {
    
    this.maximumBufferSize = maximumBufferSize;
    return this;
  }

   /**
   * maximum size of buffer
   * minimum: 0
   * maximum: 4294967295
   * @return maximumBufferSize
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MAXIMUM_BUFFER_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaximumBufferSize() {
    return maximumBufferSize;
  }


  @JsonProperty(JSON_PROPERTY_MAXIMUM_BUFFER_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaximumBufferSize(Integer maximumBufferSize) {
    this.maximumBufferSize = maximumBufferSize;
  }


  public SubscriptionSettings minimumErrorInterval(Integer minimumErrorInterval) {
    
    this.minimumErrorInterval = minimumErrorInterval;
    return this;
  }

   /**
   * minimum error interval
   * minimum: 0
   * maximum: 4294967295
   * @return minimumErrorInterval
  **/
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MINIMUM_ERROR_INTERVAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMinimumErrorInterval() {
    return minimumErrorInterval;
  }


  @JsonProperty(JSON_PROPERTY_MINIMUM_ERROR_INTERVAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinimumErrorInterval(Integer minimumErrorInterval) {
    this.minimumErrorInterval = minimumErrorInterval;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SubscriptionSettings SubscriptionSettings = (SubscriptionSettings) o;
    return Objects.equals(this.minimumPublishInterval, SubscriptionSettings.minimumPublishInterval) &&
        Objects.equals(this.minimumSampleInterval, SubscriptionSettings.minimumSampleInterval) &&
        Objects.equals(this.maximumBufferSize, SubscriptionSettings.maximumBufferSize) &&
        Objects.equals(this.minimumErrorInterval, SubscriptionSettings.minimumErrorInterval);
  }

  @Override
  public int hashCode() {
    return Objects.hash(minimumPublishInterval, minimumSampleInterval, maximumBufferSize, minimumErrorInterval);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SubscriptionSettings {\n");
    sb.append("    minimumPublishInterval: ").append(toIndentedString(minimumPublishInterval)).append("\n");
    sb.append("    minimumSampleInterval: ").append(toIndentedString(minimumSampleInterval)).append("\n");
    sb.append("    maximumBufferSize: ").append(toIndentedString(maximumBufferSize)).append("\n");
    sb.append("    minimumErrorInterval: ").append(toIndentedString(minimumErrorInterval)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `minimumPublishInterval` to the URL query string
    if (getMinimumPublishInterval() != null) {
      try {
        joiner.add(String.format("%sminimumPublishInterval%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getMinimumPublishInterval()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `minimumSampleInterval` to the URL query string
    if (getMinimumSampleInterval() != null) {
      try {
        joiner.add(String.format("%sminimumSampleInterval%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getMinimumSampleInterval()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `maximumBufferSize` to the URL query string
    if (getMaximumBufferSize() != null) {
      try {
        joiner.add(String.format("%smaximumBufferSize%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getMaximumBufferSize()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `minimumErrorInterval` to the URL query string
    if (getMinimumErrorInterval() != null) {
      try {
        joiner.add(String.format("%sminimumErrorInterval%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getMinimumErrorInterval()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

