/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetUnconfirmedServiceRequestUnknown extends BACnetUnconfirmedServiceRequest
    implements Message {

  // Accessors for discriminator values.
  public BACnetUnconfirmedServiceChoice getServiceChoice() {
    return null;
  }

  // Properties.
  protected final byte[] unknownBytes;

  // Arguments.
  protected final Integer serviceRequestLength;

  public BACnetUnconfirmedServiceRequestUnknown(byte[] unknownBytes, Integer serviceRequestLength) {
    super(serviceRequestLength);
    this.unknownBytes = unknownBytes;
    this.serviceRequestLength = serviceRequestLength;
  }

  public byte[] getUnknownBytes() {
    return unknownBytes;
  }

  @Override
  protected void serializeBACnetUnconfirmedServiceRequestChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetUnconfirmedServiceRequestUnknown");

    // Array Field (unknownBytes)
    writeByteArrayField("unknownBytes", unknownBytes, writeByteArray(writeBuffer, 8));

    writeBuffer.popContext("BACnetUnconfirmedServiceRequestUnknown");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    BACnetUnconfirmedServiceRequestUnknown _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Array field
    if (unknownBytes != null) {
      lengthInBits += 8 * unknownBytes.length;
    }

    return lengthInBits;
  }

  public static BACnetUnconfirmedServiceRequestBuilder
      staticParseBACnetUnconfirmedServiceRequestBuilder(
          ReadBuffer readBuffer, Integer serviceRequestLength) throws ParseException {
    readBuffer.pullContext("BACnetUnconfirmedServiceRequestUnknown");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    byte[] unknownBytes =
        readBuffer.readByteArray(
            "unknownBytes",
            Math.toIntExact(
                ((((serviceRequestLength) > (0))) ? ((serviceRequestLength) - (1)) : 0)));

    readBuffer.closeContext("BACnetUnconfirmedServiceRequestUnknown");
    // Create the instance
    return new BACnetUnconfirmedServiceRequestUnknownBuilderImpl(
        unknownBytes, serviceRequestLength);
  }

  public static class BACnetUnconfirmedServiceRequestUnknownBuilderImpl
      implements BACnetUnconfirmedServiceRequest.BACnetUnconfirmedServiceRequestBuilder {
    private final byte[] unknownBytes;
    private final Integer serviceRequestLength;

    public BACnetUnconfirmedServiceRequestUnknownBuilderImpl(
        byte[] unknownBytes, Integer serviceRequestLength) {
      this.unknownBytes = unknownBytes;
      this.serviceRequestLength = serviceRequestLength;
    }

    public BACnetUnconfirmedServiceRequestUnknown build(Integer serviceRequestLength) {

      BACnetUnconfirmedServiceRequestUnknown bACnetUnconfirmedServiceRequestUnknown =
          new BACnetUnconfirmedServiceRequestUnknown(unknownBytes, serviceRequestLength);
      return bACnetUnconfirmedServiceRequestUnknown;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetUnconfirmedServiceRequestUnknown)) {
      return false;
    }
    BACnetUnconfirmedServiceRequestUnknown that = (BACnetUnconfirmedServiceRequestUnknown) o;
    return (getUnknownBytes() == that.getUnknownBytes()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getUnknownBytes());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
