/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetPropertyStatesUnsignedValue is the corresponding interface of BACnetPropertyStatesUnsignedValue
type BACnetPropertyStatesUnsignedValue interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetPropertyStates
	// GetUnsignedValue returns UnsignedValue (property field)
	GetUnsignedValue() BACnetContextTagUnsignedInteger
	// IsBACnetPropertyStatesUnsignedValue is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetPropertyStatesUnsignedValue()
	// CreateBuilder creates a BACnetPropertyStatesUnsignedValueBuilder
	CreateBACnetPropertyStatesUnsignedValueBuilder() BACnetPropertyStatesUnsignedValueBuilder
}

// _BACnetPropertyStatesUnsignedValue is the data-structure of this message
type _BACnetPropertyStatesUnsignedValue struct {
	BACnetPropertyStatesContract
	UnsignedValue BACnetContextTagUnsignedInteger
}

var _ BACnetPropertyStatesUnsignedValue = (*_BACnetPropertyStatesUnsignedValue)(nil)
var _ BACnetPropertyStatesRequirements = (*_BACnetPropertyStatesUnsignedValue)(nil)

// NewBACnetPropertyStatesUnsignedValue factory function for _BACnetPropertyStatesUnsignedValue
func NewBACnetPropertyStatesUnsignedValue(peekedTagHeader BACnetTagHeader, unsignedValue BACnetContextTagUnsignedInteger) *_BACnetPropertyStatesUnsignedValue {
	if unsignedValue == nil {
		panic("unsignedValue of type BACnetContextTagUnsignedInteger for BACnetPropertyStatesUnsignedValue must not be nil")
	}
	_result := &_BACnetPropertyStatesUnsignedValue{
		BACnetPropertyStatesContract: NewBACnetPropertyStates(peekedTagHeader),
		UnsignedValue:                unsignedValue,
	}
	_result.BACnetPropertyStatesContract.(*_BACnetPropertyStates)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetPropertyStatesUnsignedValueBuilder is a builder for BACnetPropertyStatesUnsignedValue
type BACnetPropertyStatesUnsignedValueBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(unsignedValue BACnetContextTagUnsignedInteger) BACnetPropertyStatesUnsignedValueBuilder
	// WithUnsignedValue adds UnsignedValue (property field)
	WithUnsignedValue(BACnetContextTagUnsignedInteger) BACnetPropertyStatesUnsignedValueBuilder
	// WithUnsignedValueBuilder adds UnsignedValue (property field) which is build by the builder
	WithUnsignedValueBuilder(func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetPropertyStatesUnsignedValueBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetPropertyStatesBuilder
	// Build builds the BACnetPropertyStatesUnsignedValue or returns an error if something is wrong
	Build() (BACnetPropertyStatesUnsignedValue, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetPropertyStatesUnsignedValue
}

// NewBACnetPropertyStatesUnsignedValueBuilder() creates a BACnetPropertyStatesUnsignedValueBuilder
func NewBACnetPropertyStatesUnsignedValueBuilder() BACnetPropertyStatesUnsignedValueBuilder {
	return &_BACnetPropertyStatesUnsignedValueBuilder{_BACnetPropertyStatesUnsignedValue: new(_BACnetPropertyStatesUnsignedValue)}
}

type _BACnetPropertyStatesUnsignedValueBuilder struct {
	*_BACnetPropertyStatesUnsignedValue

	parentBuilder *_BACnetPropertyStatesBuilder

	collectedErr []error
}

var _ (BACnetPropertyStatesUnsignedValueBuilder) = (*_BACnetPropertyStatesUnsignedValueBuilder)(nil)

func (b *_BACnetPropertyStatesUnsignedValueBuilder) setParent(contract BACnetPropertyStatesContract) {
	b.BACnetPropertyStatesContract = contract
	contract.(*_BACnetPropertyStates)._SubType = b._BACnetPropertyStatesUnsignedValue
}

func (b *_BACnetPropertyStatesUnsignedValueBuilder) WithMandatoryFields(unsignedValue BACnetContextTagUnsignedInteger) BACnetPropertyStatesUnsignedValueBuilder {
	return b.WithUnsignedValue(unsignedValue)
}

func (b *_BACnetPropertyStatesUnsignedValueBuilder) WithUnsignedValue(unsignedValue BACnetContextTagUnsignedInteger) BACnetPropertyStatesUnsignedValueBuilder {
	b.UnsignedValue = unsignedValue
	return b
}

func (b *_BACnetPropertyStatesUnsignedValueBuilder) WithUnsignedValueBuilder(builderSupplier func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetPropertyStatesUnsignedValueBuilder {
	builder := builderSupplier(b.UnsignedValue.CreateBACnetContextTagUnsignedIntegerBuilder())
	var err error
	b.UnsignedValue, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetContextTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetPropertyStatesUnsignedValueBuilder) Build() (BACnetPropertyStatesUnsignedValue, error) {
	if b.UnsignedValue == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'unsignedValue' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetPropertyStatesUnsignedValue.deepCopy(), nil
}

func (b *_BACnetPropertyStatesUnsignedValueBuilder) MustBuild() BACnetPropertyStatesUnsignedValue {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetPropertyStatesUnsignedValueBuilder) Done() BACnetPropertyStatesBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetPropertyStatesBuilder().(*_BACnetPropertyStatesBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetPropertyStatesUnsignedValueBuilder) buildForBACnetPropertyStates() (BACnetPropertyStates, error) {
	return b.Build()
}

func (b *_BACnetPropertyStatesUnsignedValueBuilder) DeepCopy() any {
	_copy := b.CreateBACnetPropertyStatesUnsignedValueBuilder().(*_BACnetPropertyStatesUnsignedValueBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetPropertyStatesUnsignedValueBuilder creates a BACnetPropertyStatesUnsignedValueBuilder
func (b *_BACnetPropertyStatesUnsignedValue) CreateBACnetPropertyStatesUnsignedValueBuilder() BACnetPropertyStatesUnsignedValueBuilder {
	if b == nil {
		return NewBACnetPropertyStatesUnsignedValueBuilder()
	}
	return &_BACnetPropertyStatesUnsignedValueBuilder{_BACnetPropertyStatesUnsignedValue: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetPropertyStatesUnsignedValue) GetParent() BACnetPropertyStatesContract {
	return m.BACnetPropertyStatesContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetPropertyStatesUnsignedValue) GetUnsignedValue() BACnetContextTagUnsignedInteger {
	return m.UnsignedValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetPropertyStatesUnsignedValue(structType any) BACnetPropertyStatesUnsignedValue {
	if casted, ok := structType.(BACnetPropertyStatesUnsignedValue); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetPropertyStatesUnsignedValue); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetPropertyStatesUnsignedValue) GetTypeName() string {
	return "BACnetPropertyStatesUnsignedValue"
}

func (m *_BACnetPropertyStatesUnsignedValue) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).getLengthInBits(ctx))

	// Simple field (unsignedValue)
	lengthInBits += m.UnsignedValue.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetPropertyStatesUnsignedValue) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetPropertyStatesUnsignedValue) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetPropertyStates, peekedTagNumber uint8) (__bACnetPropertyStatesUnsignedValue BACnetPropertyStatesUnsignedValue, err error) {
	m.BACnetPropertyStatesContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetPropertyStatesUnsignedValue"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetPropertyStatesUnsignedValue")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	unsignedValue, err := ReadSimpleField[BACnetContextTagUnsignedInteger](ctx, "unsignedValue", ReadComplex[BACnetContextTagUnsignedInteger](BACnetContextTagParseWithBufferProducer[BACnetContextTagUnsignedInteger]((uint8)(peekedTagNumber), (BACnetDataType)(BACnetDataType_UNSIGNED_INTEGER)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'unsignedValue' field"))
	}
	m.UnsignedValue = unsignedValue

	if closeErr := readBuffer.CloseContext("BACnetPropertyStatesUnsignedValue"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetPropertyStatesUnsignedValue")
	}

	return m, nil
}

func (m *_BACnetPropertyStatesUnsignedValue) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetPropertyStatesUnsignedValue) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetPropertyStatesUnsignedValue"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetPropertyStatesUnsignedValue")
		}

		if err := WriteSimpleField[BACnetContextTagUnsignedInteger](ctx, "unsignedValue", m.GetUnsignedValue(), WriteComplex[BACnetContextTagUnsignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'unsignedValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetPropertyStatesUnsignedValue"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetPropertyStatesUnsignedValue")
		}
		return nil
	}
	return m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetPropertyStatesUnsignedValue) IsBACnetPropertyStatesUnsignedValue() {}

func (m *_BACnetPropertyStatesUnsignedValue) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetPropertyStatesUnsignedValue) deepCopy() *_BACnetPropertyStatesUnsignedValue {
	if m == nil {
		return nil
	}
	_BACnetPropertyStatesUnsignedValueCopy := &_BACnetPropertyStatesUnsignedValue{
		m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).deepCopy(),
		utils.DeepCopy[BACnetContextTagUnsignedInteger](m.UnsignedValue),
	}
	_BACnetPropertyStatesUnsignedValueCopy.BACnetPropertyStatesContract.(*_BACnetPropertyStates)._SubType = m
	return _BACnetPropertyStatesUnsignedValueCopy
}

func (m *_BACnetPropertyStatesUnsignedValue) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
