/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataAccessPointAll is the corresponding interface of BACnetConstructedDataAccessPointAll
type BACnetConstructedDataAccessPointAll interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// IsBACnetConstructedDataAccessPointAll is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataAccessPointAll()
	// CreateBuilder creates a BACnetConstructedDataAccessPointAllBuilder
	CreateBACnetConstructedDataAccessPointAllBuilder() BACnetConstructedDataAccessPointAllBuilder
}

// _BACnetConstructedDataAccessPointAll is the data-structure of this message
type _BACnetConstructedDataAccessPointAll struct {
	BACnetConstructedDataContract
}

var _ BACnetConstructedDataAccessPointAll = (*_BACnetConstructedDataAccessPointAll)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataAccessPointAll)(nil)

// NewBACnetConstructedDataAccessPointAll factory function for _BACnetConstructedDataAccessPointAll
func NewBACnetConstructedDataAccessPointAll(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataAccessPointAll {
	_result := &_BACnetConstructedDataAccessPointAll{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataAccessPointAllBuilder is a builder for BACnetConstructedDataAccessPointAll
type BACnetConstructedDataAccessPointAllBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() BACnetConstructedDataAccessPointAllBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataAccessPointAll or returns an error if something is wrong
	Build() (BACnetConstructedDataAccessPointAll, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataAccessPointAll
}

// NewBACnetConstructedDataAccessPointAllBuilder() creates a BACnetConstructedDataAccessPointAllBuilder
func NewBACnetConstructedDataAccessPointAllBuilder() BACnetConstructedDataAccessPointAllBuilder {
	return &_BACnetConstructedDataAccessPointAllBuilder{_BACnetConstructedDataAccessPointAll: new(_BACnetConstructedDataAccessPointAll)}
}

type _BACnetConstructedDataAccessPointAllBuilder struct {
	*_BACnetConstructedDataAccessPointAll

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataAccessPointAllBuilder) = (*_BACnetConstructedDataAccessPointAllBuilder)(nil)

func (b *_BACnetConstructedDataAccessPointAllBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataAccessPointAll
}

func (b *_BACnetConstructedDataAccessPointAllBuilder) WithMandatoryFields() BACnetConstructedDataAccessPointAllBuilder {
	return b
}

func (b *_BACnetConstructedDataAccessPointAllBuilder) Build() (BACnetConstructedDataAccessPointAll, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataAccessPointAll.deepCopy(), nil
}

func (b *_BACnetConstructedDataAccessPointAllBuilder) MustBuild() BACnetConstructedDataAccessPointAll {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataAccessPointAllBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataAccessPointAllBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataAccessPointAllBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataAccessPointAllBuilder().(*_BACnetConstructedDataAccessPointAllBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataAccessPointAllBuilder creates a BACnetConstructedDataAccessPointAllBuilder
func (b *_BACnetConstructedDataAccessPointAll) CreateBACnetConstructedDataAccessPointAllBuilder() BACnetConstructedDataAccessPointAllBuilder {
	if b == nil {
		return NewBACnetConstructedDataAccessPointAllBuilder()
	}
	return &_BACnetConstructedDataAccessPointAllBuilder{_BACnetConstructedDataAccessPointAll: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataAccessPointAll) GetObjectTypeArgument() BACnetObjectType {
	return BACnetObjectType_ACCESS_POINT
}

func (m *_BACnetConstructedDataAccessPointAll) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_ALL
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataAccessPointAll) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataAccessPointAll(structType any) BACnetConstructedDataAccessPointAll {
	if casted, ok := structType.(BACnetConstructedDataAccessPointAll); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataAccessPointAll); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataAccessPointAll) GetTypeName() string {
	return "BACnetConstructedDataAccessPointAll"
}

func (m *_BACnetConstructedDataAccessPointAll) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_BACnetConstructedDataAccessPointAll) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataAccessPointAll) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataAccessPointAll BACnetConstructedDataAccessPointAll, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataAccessPointAll"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataAccessPointAll")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Validation
	if !(bool((1) == (2))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "All should never occur in context of constructed data. If it does please report"})
	}

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataAccessPointAll"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataAccessPointAll")
	}

	return m, nil
}

func (m *_BACnetConstructedDataAccessPointAll) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataAccessPointAll) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataAccessPointAll"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataAccessPointAll")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataAccessPointAll"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataAccessPointAll")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataAccessPointAll) IsBACnetConstructedDataAccessPointAll() {}

func (m *_BACnetConstructedDataAccessPointAll) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataAccessPointAll) deepCopy() *_BACnetConstructedDataAccessPointAll {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataAccessPointAllCopy := &_BACnetConstructedDataAccessPointAll{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
	}
	_BACnetConstructedDataAccessPointAllCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataAccessPointAllCopy
}

func (m *_BACnetConstructedDataAccessPointAll) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
