/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.event;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.event.Event;
import javax.enterprise.inject.spi.EventMetadata;
import javax.enterprise.util.TypeLiteral;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.event.EventMetadataImpl;
import org.apache.webbeans.util.Asserts;

public class EventImpl<T>
implements Event<T>,
Serializable {
    private static final long serialVersionUID = 393021493190378023L;
    private EventMetadataImpl metadata;
    private transient WebBeansContext webBeansContext;

    public EventImpl(EventMetadata metadata, WebBeansContext webBeansContext) {
        Asserts.assertNotNull(metadata, "event metadata");
        this.metadata = this.wrapMetadata(metadata);
        this.webBeansContext = webBeansContext;
    }

    private EventMetadataImpl wrapMetadata(EventMetadata metadata) {
        if (metadata instanceof EventMetadataImpl) {
            return (EventMetadataImpl)metadata;
        }
        Set qualifiers = metadata.getQualifiers();
        return new EventMetadataImpl(null, metadata.getType(), metadata.getInjectionPoint(), qualifiers.toArray(new Annotation[qualifiers.size()]), this.webBeansContext);
    }

    public void fire(T event) {
        Class<?> eventType = event.getClass();
        this.webBeansContext.getWebBeansUtil().validEventType(eventType.getClass(), this.metadata.getType());
        this.webBeansContext.getBeanManagerImpl().fireEvent(event, this.metadata.select(eventType, new Annotation[0]), false);
    }

    public Event<T> select(Annotation ... bindings) {
        return new EventImpl<T>(this.metadata.select(bindings), this.webBeansContext);
    }

    public <U extends T> Event<U> select(Class<U> subtype, Annotation ... bindings) {
        return new EventImpl<T>(this.metadata.select(subtype, bindings), this.webBeansContext);
    }

    public <U extends T> Event<U> select(TypeLiteral<U> subtype, Annotation ... bindings) {
        return new EventImpl<T>(this.metadata.select(subtype, bindings), this.webBeansContext);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.webBeansContext = WebBeansContext.currentInstance();
    }

    public EventMetadataImpl getMetadata() {
        return this.metadata;
    }
}

