/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.ontonotes;

import java.io.File;
import java.nio.charset.StandardCharsets;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.commons.Internal;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.DirectorySampleStream;
import opennlp.tools.formats.convert.FileToStringSampleStream;
import opennlp.tools.formats.ontonotes.OntoNotesFormatParameters;
import opennlp.tools.formats.ontonotes.OntoNotesNameSampleStream;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.util.ObjectStream;

@Internal
public class OntoNotesNameSampleStreamFactory
extends AbstractSampleStreamFactory<NameSample, OntoNotesFormatParameters> {
    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(NameSample.class, "ontonotes", new OntoNotesNameSampleStreamFactory());
    }

    public OntoNotesNameSampleStreamFactory() {
        super(OntoNotesFormatParameters.class);
    }

    @Override
    public ObjectStream<NameSample> create(String[] args) {
        if (args == null) {
            throw new IllegalArgumentException("Passed args must not be null!");
        }
        OntoNotesFormatParameters params = ArgumentParser.parse(args, OntoNotesFormatParameters.class);
        File ontoDir = new File(params.getOntoNotesDir());
        if (!ontoDir.isDirectory() || !ontoDir.exists()) {
            throw new TerminateToolException(-1, "The specified OntoNotes directory is not valid!");
        }
        DirectorySampleStream documentStream = new DirectorySampleStream(new File(params.getOntoNotesDir()), file -> {
            if (file.isFile()) {
                return file.getName().endsWith(".name");
            }
            return file.isDirectory();
        }, true);
        return new OntoNotesNameSampleStream(new FileToStringSampleStream(documentStream, StandardCharsets.UTF_8));
    }
}

