/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./src/main/omutils.js":
/*!*****************************!*\
  !*** ./src/main/omutils.js ***!
  \*****************************/
/***/ ((module) => {

/* Licensed under the Apache License, Version 2.0 (the "License") http://www.apache.org/licenses/LICENSE-2.0 */

let options, alertId = 0;

function _init(_options) {
	options = _options;
}
function _tmpl(tmplId, newId) {
	return $(tmplId).clone().attr('id', newId || '');
}
function __alert(level, msg, autohideAfter) {
	const holder = document.getElementById('alert-holder');
	const curId = 'om-alert' + alertId++;
	holder.insertAdjacentHTML('beforeend',
		`<div id="${curId}" class="alert alert-${level} alert-dismissible fade show m-0" role="alert">${msg}
			<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="${holder.getAttribute('data-lbl-close')}"></button>
		</div>`);
	if (autohideAfter > 0) {
		setTimeout(() => { bootstrap.Alert.getOrCreateInstance(`#${curId}`).close();}, autohideAfter);
	}
}
function _error(msg, noAlert) {
	if (typeof(msg) === 'object') {
		msg = msg.name + ': ' + msg.message;
	}
	if (noAlert !== true) {
		__alert('danger', msg, 20000);
	}
	return console.error(msg);
}
function _debugEnabled() {
	return !!options && !!options.debug;
}
function _info() {
	if (_debugEnabled()) {
		console.info.apply(this, arguments);
	}
}
function _log() {
	if (_debugEnabled()) {
		console.log.apply(this, arguments);
	}
}
function _sendMessage(_m, _base) {
	const base = _base || {}
		, m = _m || {}
		, msg = JSON.stringify(Object.assign({}, base, m));
	Wicket.WebSocket.send(msg);
}
function _requestNotifyPermission(callback, elseCallback) {
	if (typeof(Notification) !== 'undefined'
		&& Notification.permission !== 'granted'
		&& Notification.permission !== 'denied') {
		function onRequest(permission) {
			if (permission === 'granted') {
				callback();
			}
		}
		Promise.resolve(Notification.requestPermission()).then(onRequest);
	} else {
		_info('No notification API for this browser');
		if (typeof(elseCallback) === 'function') {
			elseCallback();
		}
	}
}
function _notify(msg, tag, elseCallback) {
	if (typeof(Notification) !== 'undefined'
		&& window === window.parent) {
		function _newMessage() {
			const opts = {
					tag: tag
				};
			try {
				new Notification(msg, opts);
			} catch (e) {
				console.error("Failed to create Notification" + e)
			}
		}
		if (Notification.permission === 'granted') {
			_newMessage();
		} else {
			_requestNotifyPermission(() => _newMessage());
		}
	} else {
		_info('No notification API for this browser');
		if (typeof(elseCallback) === 'function') {
			elseCallback();
		}
	}
}

module.exports = {
	init: _init
	, tmpl: _tmpl
	, debugEnabled: _debugEnabled
	, enableDebug: function() {
		if (!!options) {
			options.debug = true;
		}
	}
	, sendMessage: _sendMessage
	, alert: __alert
	, error: _error
	, info: _info
	, log: _log
	, wbAction: function(_m) {
		_sendMessage(_m, {area: 'room', type: 'wb'});
	}
	, roomAction: function(_m) {
		_sendMessage(_m, {area: 'room', type: 'room'});
	}
	, setCssVar: function(key, val) {
		document.querySelector('body').style.setProperty(key, val);
	}
	, ping: function() {
		setTimeout(() => {
			_sendMessage({type: 'ping'});
			fetch('./ping', {cache: "no-store"});
		}, 30000);
	}
	, notify: _notify
	, requestNotifyPermission: _requestNotifyPermission
};


/***/ }),

/***/ "./src/main/settings.js":
/*!******************************!*\
  !*** ./src/main/settings.js ***!
  \******************************/
/***/ ((module) => {

/* Licensed under the Apache License, Version 2.0 (the "License") http://www.apache.org/licenses/LICENSE-2.0 */
const key = 'openmeetings';
function _load() {
	let s = {};
	try {
		s = JSON.parse(localStorage.getItem(key)) || s;
	} catch (e) {
		// no-op
	}
	return s;
}
function _save(s) {
	const _s = JSON.stringify(s);
	localStorage.setItem(key, _s);
	return _s;
}

module.exports = {
	isRtl: 'rtl' === document.querySelector('html').getAttribute('dir')
	, load: _load
	, save: _save
};


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
(() => {
/*!***************************!*\
  !*** ./src/main/index.js ***!
  \***************************/
/* Licensed under the Apache License, Version 2.0 (the "License") http://www.apache.org/licenses/LICENSE-2.0 */
Wicket.BrowserInfo.collectExtraInfo = function(info) {
	const l = window.location;
	info.codebase = l.origin + l.pathname;
	info.settings = Settings.load();
};

function _updateResize() {
	const doc = document.documentElement;
	doc.style.setProperty('--app-height', `${window.innerHeight}px`)
}
$(window).on('resize', _updateResize);
//initial resize
_updateResize();

Object.assign(window, {
	Settings: __webpack_require__(/*! ./settings */ "./src/main/settings.js")
	, OmUtil: __webpack_require__(/*! ./omutils */ "./src/main/omutils.js")
	//Fix to move the close icon on top of the .ui-dialog-titlebar cause otherwise
	// touch-events are broken and you won't be able to close the dialog
	, fixJQueryUIDialogTouch: function(dialog) {
		dialog.parent().find('.ui-dialog-titlebar-close').appendTo(dialog.parent());
	}
	, showBusyIndicator: function() {
		$('#busy-indicator').show();
	}
	, hideBusyIndicator: function() {
		$('#busy-indicator').hide();
	}
});

})();

/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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