/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.ui.calendar;

import java.time.LocalDate;
import java.util.List;
import org.apache.wicket.request.IRequestParameters;
import org.wicketstuff.jquery.core.behavior.AjaxCallbackBehavior;
import org.wicketstuff.jquery.ui.calendar.CalendarEvent;
import org.wicketstuff.jquery.ui.calendar.CalendarModel;
import org.wicketstuff.jquery.ui.calendar.ICalendarVisitor;

public class CalendarModelBehavior
extends AjaxCallbackBehavior {
    private static final long serialVersionUID = 1L;
    private final CalendarModel model;

    public CalendarModelBehavior(CalendarModel model) {
        this.model = model;
    }

    protected void setStartDate(CalendarModel model, LocalDate date) {
        model.setStart(date);
    }

    protected void setEndDate(CalendarModel model, LocalDate date) {
        model.setEnd(date);
    }

    protected String getResponse(IRequestParameters parameters) {
        String start = parameters.getParameterValue("start").toString();
        String end = parameters.getParameterValue("end").toString();
        StringBuilder builder = new StringBuilder("[ ");
        if (this.model != null) {
            this.setStartDate(this.model, LocalDate.parse(start));
            this.setEndDate(this.model, LocalDate.parse(end));
            List list = (List)this.model.getObject();
            if (list != null) {
                int count = 0;
                for (CalendarEvent event : list) {
                    if (this.model instanceof ICalendarVisitor) {
                        event.accept((ICalendarVisitor)((Object)this.model));
                    }
                    if (count++ > 0) {
                        builder.append(", ");
                    }
                    builder.append(event.toString());
                }
            }
        }
        return builder.append(" ]").toString();
    }
}

