/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import org.jsoup.helper.Validate;
import org.jsoup.internal.SimpleBufferedInput;
import org.jspecify.annotations.Nullable;

public class SimpleStreamReader
extends Reader {
    private final InputStream in;
    private final CharsetDecoder decoder;
    private @Nullable ByteBuffer byteBuf;

    public SimpleStreamReader(InputStream in, Charset charset) {
        this.in = in;
        this.decoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        byte[] buf = SimpleBufferedInput.BufferPool.borrow();
        this.byteBuf = ByteBuffer.wrap(buf);
        this.byteBuf.flip();
    }

    @Override
    public int read(char[] charArray, int off, int len) throws IOException {
        Validate.notNull(this.byteBuf);
        CharBuffer charBuf = CharBuffer.wrap(charArray, off, len);
        if (charBuf.position() != 0) {
            charBuf = charBuf.slice();
        }
        boolean readFully = false;
        while (true) {
            CoderResult result;
            if ((result = this.decoder.decode(this.byteBuf, charBuf, readFully)).isUnderflow()) {
                if (readFully || !charBuf.hasRemaining() || charBuf.position() > 0 && this.in.available() <= 0) break;
                int read = this.bufferUp();
                if (read >= 0) continue;
                readFully = true;
                if (charBuf.position() != 0 || this.byteBuf.hasRemaining()) continue;
                break;
            }
            if (result.isOverflow()) break;
            result.throwException();
        }
        if (readFully) {
            this.decoder.reset();
        }
        if (charBuf.position() == 0) {
            return -1;
        }
        return charBuf.position();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int bufferUp() throws IOException {
        assert (this.byteBuf != null);
        this.byteBuf.compact();
        try {
            int pos = this.byteBuf.position();
            int remaining = this.byteBuf.limit() - pos;
            int read = this.in.read(this.byteBuf.array(), this.byteBuf.arrayOffset() + pos, remaining);
            if (read < 0) {
                int n = read;
                return n;
            }
            if (read == 0) {
                throw new IOException("Underlying input stream returned zero bytes");
            }
            this.byteBuf.position(pos + read);
        }
        finally {
            this.byteBuf.flip();
        }
        return this.byteBuf.remaining();
    }

    @Override
    public void close() throws IOException {
        if (this.byteBuf == null) {
            return;
        }
        SimpleBufferedInput.BufferPool.release(this.byteBuf.array());
        this.byteBuf = null;
        this.in.close();
    }
}

