/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.datastores.hazelcast;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.serialization.impl.AbstractSerializationService;
import com.hazelcast.map.IMap;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.StreamSerializer;
import com.hazelcast.spi.impl.SerializationServiceSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.page.IManageablePage;
import org.apache.wicket.pageStore.AbstractPersistentPageStore;
import org.apache.wicket.pageStore.IPersistedPage;
import org.apache.wicket.pageStore.IPersistentPageStore;
import org.apache.wicket.pageStore.SerializedPage;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastDataStore
extends AbstractPersistentPageStore
implements IPersistentPageStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(HazelcastDataStore.class);
    private final HazelcastInstance hazelcast;

    public HazelcastDataStore(String applicationName, HazelcastInstance hazelcast) {
        super(applicationName);
        SerializationService serializationService;
        this.hazelcast = (HazelcastInstance)Args.notNull((Object)hazelcast, (String)"hazelcast");
        if (hazelcast instanceof SerializationServiceSupport && (serializationService = ((SerializationServiceSupport)hazelcast).getSerializationService()) instanceof AbstractSerializationService) {
            ((AbstractSerializationService)serializationService).register(SerializedPage.class, (Serializer)new SerializedPageSerializer());
        }
    }

    public boolean supportsVersioning() {
        return true;
    }

    protected IManageablePage getPersistedPage(String sessionIdentifier, int id) {
        IMap map = this.hazelcast.getMap(sessionIdentifier);
        if (map != null) {
            SerializedPage page = (SerializedPage)map.get((Object)id);
            LOGGER.debug("Got {} for session '{}' and page id '{}'", new Object[]{page, sessionIdentifier, id});
            if (page != null) {
                return page;
            }
        }
        return null;
    }

    protected void removePersistedPage(String sessionIdentifier, IManageablePage page) {
        IMap map = this.hazelcast.getMap(sessionIdentifier);
        if (map != null) {
            map.delete((Object)page.getPageId());
            LOGGER.debug("Deleted page for session '{}' and page with id '{}'", (Object)sessionIdentifier, (Object)page.getPageId());
        }
    }

    protected void removeAllPersistedPages(String sessionIdentifier) {
        IMap map = this.hazelcast.getMap(sessionIdentifier);
        if (map != null) {
            map.clear();
            LOGGER.debug("Deleted page for session '{}'", (Object)sessionIdentifier);
        }
    }

    protected void addPersistedPage(String sessionIdentifier, IManageablePage page) {
        if (!(page instanceof SerializedPage)) {
            throw new WicketRuntimeException("HazelcastDataStore works with serialized pages only");
        }
        SerializedPage serializedPage = (SerializedPage)page;
        IMap map = this.hazelcast.getMap(sessionIdentifier);
        map.put((Object)page.getPageId(), (Object)serializedPage);
        LOGGER.debug("Inserted page for session '{}' and page id '{}'", (Object)sessionIdentifier, (Object)page.getPageId());
    }

    public void destroy() {
        if (this.hazelcast != null) {
            this.hazelcast.shutdown();
        }
    }

    public Set<String> getSessionIdentifiers() {
        return this.hazelcast.getConfig().getMapConfigs().keySet();
    }

    public Bytes getTotalSize() {
        long bytes = 0L;
        for (DistributedObject object : this.hazelcast.getDistributedObjects()) {
            IMap map = this.hazelcast.getMap(object.getName());
            bytes += map.getLocalMapStats().getHeapCost();
        }
        return Bytes.bytes((long)bytes);
    }

    public List<IPersistedPage> getPersistedPages(String contextIdentifier) {
        ArrayList<IPersistedPage> pages = new ArrayList<IPersistedPage>();
        IMap map = this.hazelcast.getMap(contextIdentifier);
        if (map != null) {
            for (SerializedPage page : map.values()) {
                pages.add((IPersistedPage)new AbstractPersistentPageStore.PersistedPage(page.getPageId(), page.getPageType(), (long)page.getData().length));
            }
        }
        return pages;
    }

    private static final class SerializedPageSerializer
    implements StreamSerializer<SerializedPage> {
        private SerializedPageSerializer() {
        }

        public void write(ObjectDataOutput out, SerializedPage page) throws IOException {
            out.writeInt(page.getPageId());
            out.writeUTF(page.getPageType());
            out.writeByteArray(page.getData());
        }

        public SerializedPage read(ObjectDataInput in) throws IOException {
            return new SerializedPage(in.readInt(), in.readUTF(), in.readByteArray());
        }

        public int getTypeId() {
            return 42;
        }

        public void destroy() {
        }
    }
}

