/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.request.extended;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.util.Oid;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ExtendedOperationFactory;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.model.message.ExtendedRequest;
import org.apache.directory.api.ldap.model.message.OpaqueExtendedRequest;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreExtendedRequestName
extends GrammarAction<LdapMessageContainer<ExtendedRequest>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreExtendedRequestName.class);

    public StoreExtendedRequestName() {
        super("Store ExtendedRequest Name");
    }

    @Override
    public void action(LdapMessageContainer<ExtendedRequest> container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            String msg = I18n.err(I18n.ERR_05122_NULL_NAME, new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        byte[] requestNameBytes = tlv.getValue().getData();
        String requestName = Strings.utf8ToString(requestNameBytes);
        try {
            if (!Oid.isOid(requestName)) {
                String msg = I18n.err(I18n.ERR_05121_INVALID_REQUEST_NAME_OID, requestName, Strings.dumpBytes(requestNameBytes));
                LOG.error(msg);
                throw new DecoderException(msg);
            }
            LdapApiService codec = container.getLdapCodecService();
            ExtendedOperationFactory factory = codec.getExtendedRequestFactories().get(requestName);
            ExtendedRequest extendedRequest = factory == null ? new OpaqueExtendedRequest() : factory.newRequest();
            extendedRequest.setMessageId(container.getMessageId());
            container.setMessage(extendedRequest);
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_05126_OID_READ, extendedRequest.getRequestName()));
            }
        }
        catch (DecoderException de) {
            String msg = I18n.err(I18n.ERR_05121_INVALID_REQUEST_NAME_OID, requestName, Strings.dumpBytes(requestNameBytes));
            LOG.error(I18n.err(I18n.ERR_05114_ERROR_MESSAGE, msg, de.getMessage()));
            throw de;
        }
        container.setGrammarEndAllowed(true);
    }
}

