/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.urlfragment;

import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.IRequestParameters;
import org.wicketstuff.urlfragment.UrlFragment;
import org.wicketstuff.urlfragment.UrlParametersReceivingBehavior;

public abstract class AsyncUrlFragmentAwarePanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private transient AjaxRequestTarget target = null;

    public AsyncUrlFragmentAwarePanel(String id) {
        super(id);
        this.initializeFragmentBehavior();
    }

    public AsyncUrlFragmentAwarePanel(String id, IModel<?> model) {
        super(id, model);
        this.initializeFragmentBehavior();
    }

    private void initializeFragmentBehavior() {
        this.setOutputMarkupId(true);
        this.add(new Behavior[]{new UrlParametersReceivingBehavior(this.getOptions(), new Component[0]){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onParameterArrival(IRequestParameters requestParameters, AjaxRequestTarget target) {
                AsyncUrlFragmentAwarePanel.this.target = target;
                AsyncUrlFragmentAwarePanel.this.onParameterIncome(requestParameters, target);
                AsyncUrlFragmentAwarePanel.this.target = null;
                target.add(new Component[]{AsyncUrlFragmentAwarePanel.this});
            }
        }});
    }

    protected Map<String, String> getOptions() {
        return new HashMap<String, String>();
    }

    protected abstract void onParameterIncome(IRequestParameters var1, AjaxRequestTarget var2);

    protected UrlFragment urlFragment() {
        return new UrlFragment((IPartialPageRequestHandler)this.target);
    }
}

