/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.core;

import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.head.PriorityHeaderItem;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Generics;
import org.wicketstuff.jquery.core.resource.JQueryUrlResourceReference;
import org.wicketstuff.jquery.core.settings.JQueryLibrarySettings;

public abstract class JQueryAbstractBehavior
extends Behavior {
    private static final long serialVersionUID = 1L;
    private final List<ResourceReference> references = Generics.newArrayList();

    public static JQueryLibrarySettings getJQueryLibrarySettings() {
        if (Application.exists() && Application.get().getJavaScriptLibrarySettings() instanceof JQueryLibrarySettings) {
            return (JQueryLibrarySettings)Application.get().getJavaScriptLibrarySettings();
        }
        return null;
    }

    public final boolean add(ResourceReference reference) {
        return this.references.add(reference);
    }

    public void renderHead(Component component, IHeaderResponse response) {
        JQueryLibrarySettings settings = JQueryAbstractBehavior.getJQueryLibrarySettings();
        if (settings != null && settings.getJQueryGlobalizeReference() != null) {
            this.renderPriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)settings.getJQueryGlobalizeReference()), response);
        }
        for (ResourceReference reference : this.references) {
            if (reference instanceof CssResourceReference) {
                this.renderPriorityHeaderItem((HeaderItem)CssHeaderItem.forReference((ResourceReference)reference), response);
            }
            if (reference instanceof JavaScriptResourceReference) {
                this.renderPriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)reference), response);
            }
            if (!(reference instanceof JQueryUrlResourceReference)) continue;
            this.renderPriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)reference), response);
        }
        String statement = this.$();
        if (statement != null) {
            this.renderOnDomReadyScript(statement, response);
        }
    }

    protected void renderPriorityHeaderItem(HeaderItem item, IHeaderResponse response) {
        response.render((HeaderItem)new PriorityHeaderItem(item));
    }

    protected void renderOnDomReadyScript(String script, IHeaderResponse response) {
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)script));
    }

    protected abstract String $();

    public String toString() {
        return this.$();
    }
}

