/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.service.scheduler;

import com.github.openjson.JSONArray;
import jakarta.inject.Inject;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.openmeetings.core.mail.MailHandler;
import org.apache.openmeetings.core.rss.LoadAtomRssFeed;
import org.apache.openmeetings.db.dao.basic.ConfigurationDao;
import org.apache.openmeetings.db.dao.user.GroupUserDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.dto.basic.Health;
import org.apache.openmeetings.db.entity.user.Group;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.service.calendar.AppointmentLogic;
import org.apache.openmeetings.service.mail.template.subject.NewGroupUsersNotificationTemplate;
import org.apache.openmeetings.service.mail.template.subject.RecordingExpiringTemplate;
import org.apache.openmeetings.service.mail.template.subject.SubjectEmailTemplate;
import org.apache.openmeetings.service.scheduler.AbstractJob;
import org.apache.openmeetings.service.scheduler.AtomReader;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.util.crypt.CryptProvider;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="reminderJob")
public class ReminderJob
extends AbstractJob {
    private static Logger log = LoggerFactory.getLogger(ReminderJob.class);
    @Inject
    private AppointmentLogic appointmentLogic;
    @Inject
    private UserDao userDao;
    @Inject
    private MailHandler mailHandler;
    @Inject
    private ConfigurationDao cfgDao;
    @Inject
    private GroupUserDao groupUserDao;
    public Map<Long, LocalDateTime> groupNotifications = new HashMap<Long, LocalDateTime>();

    public void remindMeetings() {
        log.trace("ReminderJob.remindMeetings");
        if (!OpenmeetingsVariables.isInitComplete()) {
            return;
        }
        try {
            this.appointmentLogic.doScheduledMeetingReminder();
        }
        catch (Exception err) {
            log.error("execute", (Throwable)err);
        }
    }

    public void remindExpiringRecordings() {
        log.trace("ReminderJob.remindExpiringRecordings");
        this.processExpiringRecordings(false, (rec, days) -> {
            if (days > 0L) {
                User u = this.userDao.get(rec.getInsertedBy());
                if (u == null) {
                    log.debug("Unable to send expiration email due to recording owner is NULL, {}", rec);
                } else {
                    SubjectEmailTemplate templ = RecordingExpiringTemplate.get(u, rec, days);
                    this.mailHandler.send(u.getAddress().getEmail(), templ.getSubject(), templ.getEmail());
                }
            } else {
                log.debug("Recording is too old to send notification, {} days", (Object)days);
            }
            rec.setNotified(true);
            this.recordingDao.update(rec);
        });
    }

    public void loadRss() {
        log.trace("ReminderJob.loadRss");
        if (!OpenmeetingsVariables.isInitComplete()) {
            return;
        }
        if (!this.cfgDao.getBool("dashboard.show.rssfeed", false)) {
            log.debug("Rss disabled by Admin");
            return;
        }
        JSONArray feed = new JSONArray();
        for (String url : new String[]{this.cfgDao.getString("dashboard.rss.feed1", ""), this.cfgDao.getString("dashboard.rss.feed2", "")}) {
            if (Strings.isEmpty((String)url)) continue;
            AtomReader.load(url, feed);
        }
        if (feed.length() > 0) {
            LoadAtomRssFeed.setRss((JSONArray)feed);
        }
    }

    public void checkHealth() {
        log.trace("ReminderJob.checkHealth");
        boolean dbOk = false;
        try {
            this.cfgDao.count();
            dbOk = true;
        }
        catch (Exception e) {
            log.error("DB seems to be down");
        }
        Health.getInstance().setInited(OpenmeetingsVariables.isInitComplete()).setInstalled(CryptProvider.get() != null).setDbOk(dbOk);
    }

    public void notifyNewGroupUsers() {
        log.trace("ReminderJob.notifyNewGroupUsers");
        if (!OpenmeetingsVariables.isInitComplete()) {
            return;
        }
        LocalDateTime now = LocalDateTime.now();
        for (Group g : this.groupDao.getGroupsForUserNotifications()) {
            LocalDateTime lastChecked = this.groupNotifications.get(g.getId());
            if (lastChecked == null) {
                this.groupNotifications.put(g.getId(), now);
                continue;
            }
            if (Duration.between(lastChecked, now).minusMinutes(g.getNotifyInterval()).isNegative()) continue;
            long count = this.groupUserDao.getGroupUserCountAddedAfter(g.getId(), Date.from(lastChecked.atZone(ZoneId.systemDefault()).toInstant()));
            if (count > 0L) {
                for (User u : this.groupUserDao.getGroupModerators(g.getId())) {
                    SubjectEmailTemplate templ = NewGroupUsersNotificationTemplate.get(u, g, count);
                    this.mailHandler.send(u.getAddress().getEmail(), templ.getSubject(), templ.getEmail());
                }
            }
            this.groupNotifications.put(g.getId(), now);
        }
    }
}

