/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.service.scheduler;

import jakarta.inject.Inject;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.function.ObjLongConsumer;
import org.apache.openmeetings.db.dao.record.RecordingDao;
import org.apache.openmeetings.db.dao.user.GroupDao;
import org.apache.openmeetings.db.entity.record.Recording;
import org.apache.openmeetings.db.entity.user.Group;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJob {
    private static Logger log = LoggerFactory.getLogger(AbstractJob.class);
    @Inject
    GroupDao groupDao;
    @Inject
    RecordingDao recordingDao;

    void processExpiringRecordings(boolean notified, ObjLongConsumer<Recording> consumer) {
        if (!OpenmeetingsVariables.isInitComplete()) {
            return;
        }
        for (Group g : this.groupDao.getLimited()) {
            for (Recording rec : this.recordingDao.getExpiring(g.getId(), g.getReminderDays(), notified)) {
                try {
                    long days = (long)g.getRecordingTtl() - ChronoUnit.DAYS.between(rec.getInserted().toInstant(), Instant.now());
                    consumer.accept(rec, days);
                }
                catch (Exception e) {
                    log.error("Uexpected exception while processing expiring recordings emails", (Throwable)e);
                }
            }
        }
    }
}

